<?php
session_start();
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

// Make sure user is logged in
if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
?>


<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

<!-- Bootstrap JS (Optional, for modals, dropdowns, etc.) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-QZkq+DrIWZzPqNmgIG7K5Azqp9ul1+8F7tcbKpTxL+xQAgdk1DJjGyw+vbPzvC4f" crossorigin="anonymous"></script>
<style>
    .card-title {
        font-family: 'Segoe UI', sans-serif;
    }

    .btn-outline-primary {
        border: 1px solid #6c63ff;
        color: #6c63ff;
        transition: 0.3s;
    }

    .btn-outline-primary:hover {
        background-color: #6c63ff;
        color: white;
    }
</style>
<div class="container-fluid px-4 py-5">
    <div class="row mb-4">
        <div class="col-12">
            <h3 class="fw-bold text-white">Your Projects</h3>
            <p class="text-white">Here are the projects you've created. Contact buyers and manage your campaigns.</p>

            <div class="d-flex justify-content-end mb-4">
                <a href="create-project.php" class="btn btn-lg btn-gradient px-4 rounded-pill shadow-sm" style="background: linear-gradient(135deg, #667eea, #764ba2); color: #fff; font-weight: 600;">
                    <i class="fas fa-plus me-2"></i> Create New Project
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <?php
        // Make sure user is logged in
        if (!isset($_SESSION['userid'])) {
            echo '<div class="col-12 text-danger text-center">User not logged in.</div>';
            exit();
        }

        $userid = $_SESSION['userid'];

        // Fetch user-created products
        $query = mysqli_query($conn, "SELECT * FROM products WHERE user_id = '$userid' ORDER BY created_at DESC");

        if (mysqli_num_rows($query) > 0) {
            while ($row = mysqli_fetch_assoc($query)) {
                $name = htmlspecialchars($row['product_name']);
                $desc = substr(strip_tags($row['description']), 0, 80) . '...';
                $image = htmlspecialchars($row['image']);
                $amount = number_format($row['amount'], 2);
                $amount_bought = $row['amount_bought'] ?? '0';
                $amount_left = $row['amount_left'] ?? '0';
                $date = date("M d, Y", strtotime($row['created_at']));
                $product_id = $row['product_id'];
        ?>
                <div class="col-sm-12 col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm rounded-4 overflow-hidden position-relative">
                        <div class="ratio ratio-16x9">
                            <img src="./uploads/<?php echo $image; ?>" class="card-img-top object-fit-cover" alt="<?php echo $name; ?>">
                        </div>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title fw-semibold text-dark mb-2"><?php echo $name; ?></h5>
                            <p class="card-text text-muted small"><?php echo $desc; ?></p>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div><i class="bi bi-bag-check-fill text-success me-1"></i> Bought: <strong><?php echo $amount_bought; ?></strong></div>
                                <div><i class="bi bi-box-fill text-warning me-1"></i> Left: <strong><?php echo $amount_left; ?></strong></div>
                            </div>
                            <div class="mt-auto d-flex justify-content-between align-items-center">
                                <div>
                                    <span class="fw-bold text-success fs-6">$<?php echo $amount; ?></span><br>
                                    <small class="text-muted">Posted on <?php echo $date; ?></small>
                                </div>
                                <a href="view-buyers.php?product_id=<?php echo $product_id; ?>" class="btn btn-outline-primary btn-sm rounded-pill">
                                    Contact Buyers
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
        <?php
            }
        } else {
            echo '
        <div class="col-12">
            <div class="alert alert-warning border-2 border-warning text-center py-5 rounded-4 shadow-sm" role="alert">
                <i class="fas fa-exclamation-triangle fa-2x mb-3 text-warning"></i>
                <h4 class="fw-bold text-dark">No Projects Found!</h4>
                <p class="text-muted mb-3">You haven’t created any projects yet.</p>
                <a href="create-project.php" class="btn btn-warning btn-lg px-4 rounded-pill fw-semibold shadow-sm">
                    <i class="fas fa-plus-circle me-2"></i> Create Your First Project
                </a>
            </div>
        </div>
        ';
        }
        ?>
    </div>



    <?php include "footer.php"; ?>
</div>