<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$is_logged_in = isset($_SESSION['userid']);
$unreadCount = 0;

if ($is_logged_in) {
    $userid = $_SESSION['userid'];

    // ✅ Correct message count for user's products
    $sql = "SELECT COUNT(*) as total
            FROM product_messages pm
            JOIN products p ON pm.product_id = p.product_id
            WHERE p.user_id = ? AND pm.sender_role = 'admin'";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $userid);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $unreadCount = $row['total'];
}

$userid = $_SESSION['userid'] ?? '';

// Count all unread admin messages sent to the logged-in user across all their products
$unread_query = $conn->prepare("
    SELECT COUNT(*) as total 
    FROM product_messages 
    WHERE receiver_id = ? 
      AND sender_role = 'admin' 
      AND seen = 0
");
$unread_query->bind_param("s", $userid);
$unread_query->execute();
$unread_result = $unread_query->get_result()->fetch_assoc();
$unreadCount = $unread_result['total'] ?? 0;

?>


<aside class="fixed inset-y-0 flex-wrap items-center justify-between block w-full p-0 my-4 overflow-y-auto antialiased transition-transform duration-200 -translate-x-full bg-white border-0 shadow-xl dark:shadow-none dark:bg-slate-850 max-w-64 ease-nav-brand z-990 xl:ml-6 rounded-2xl xl:left-0 xl:translate-x-0" aria-expanded="false">
    <div class="h-19">
        <i class="absolute top-0 right-0 p-4 opacity-50 cursor-pointer fas fa-times dark:text-white text-slate-400 xl:hidden" sidenav-close></i>
        <a class="block px-8 py-6 text-sm font-semibold text-slate-700 dark:text-white whitespace-nowrap" href="dashboard.php">
            <img src="./assets/img/logo-ct-dark.png" class="inline max-h-8 dark:hidden" alt="logo" />
            <img src="./assets/img/logo-ct.png" class="hidden max-h-8 dark:inline" alt="logo" />
            <span class="ml-1">ChoicyDigitals Dashboard</span>
        </a>
    </div>

    <hr class="h-px bg-gradient-to-r from-transparent via-black/40 to-transparent dark:via-white" />

    <div class="items-center w-auto max-h-screen overflow-auto h-sidenav grow">
        <ul class="flex flex-col mb-0">

            <li>
                <a href="dashboard.php" class="nav-link">
                    <div class="icon text-blue-500"><i class="ni ni-tv-2"></i></div>
                    <span>Dashboard</span>
                </a>
            </li>

            <li>
                <a href="deposit.php" class="nav-link">
                    <div class="icon text-green-500"><i class="ni ni-money-coins"></i></div>
                    <span>Deposit</span>
                </a>
            </li>

            <li>
                <a href="projects.php" class="nav-link">
                    <div class="icon text-purple-500"><i class="ni ni-collection"></i></div>
                    <span>Market Place</span>
                </a>
            </li>

            <li>
                <a href="user_projects.php" class="nav-link">
                    <div class="icon text-purple-500"><i class="ni ni-collection"></i></div>
                    <span>My Projects</span>
                </a>
            </li>

            <li>
                <a href="create-project.php" class="nav-link">
                    <div class="icon text-cyan-500"><i class="ni ni-fat-add"></i></div>
                    <span>Create Projects</span>
                </a>
            </li>

            <li>
                <a href="withdraw.php" class="nav-link">
                    <div class="icon text-red-500"><i class="ni ni-bold-up"></i></div>
                    <span>Withdrawal</span>
                </a>
            </li>

            <li>
                <a href="messages.php" class="nav-link">
                    <div class="icon text-orange-500 position-relative">
                        <i class="ni ni-email-83"></i>
                        <?php if ($unreadCount > 0) : ?>
                            <span style="position: absolute; top: -8px; right: -8px; background: red; color: white; font-size: 10px; padding: 2px 6px; border-radius: 50%;">
                                <?php echo $unreadCount; ?>
                            </span>
                        <?php endif; ?>
                    </div>
                    <span>Messages</span>
                </a>
            </li>


            <li class="mt-4">
                <h6 class="pl-6 text-xs font-bold uppercase opacity-60 dark:text-white">Account Pages</h6>
            </li>

            <li>
                <a href="profit.php" class="nav-link">
                    <div class="icon text-red-500"><i class="ni ni-bold-up"></i></div>
                    <span>Monitor Profit</span>
                </a>
            </li>

            <li>
                <a href="profile.php" class="nav-link">
                    <div class="icon text-slate-700"><i class="ni ni-single-02"></i></div>
                    <span>Profile</span>
                </a>
            </li>

            <?php if ($is_logged_in) : ?>
                <li>
                    <a href="logout.php" class="nav-link">
                        <div class="icon text-orange-500"><i class="ni ni-button-power"></i></div>
                        <span>Sign Out</span>
                    </a>
                </li>
            <?php else : ?>
                <li>
                    <a href="./pages/sign-in.html" class="nav-link">
                        <div class="icon text-orange-500"><i class="ni ni-key-25"></i></div>
                        <span>Sign In</span>
                    </a>
                </li>
            <?php endif; ?>

            

        </ul>
        
    </div>
    <div style="background: linear-gradient(135deg, #7f5af0, #5f2eea); color: white; padding: 15px; border-radius: 12px; margin: 20px;">
                <h6 style="font-weight: bold; margin-bottom: 10px;">Need Help?</h6>
                <p style="font-size: 13px; margin-bottom: 15px;">Contact our team if you have questions or issues with your account.</p>
                <a href="mailto:choicydigitalmarketing@gmail.com?subject=Support Request" class="btn btn-light w-100  fw-bold">
                    <i class="fas fa-envelope me-2"></i> Email Support
                </a>
            </div>
</aside>

<style>
    .nav-link {
        display: flex !important;
        align-items: center;
        padding: 1rem 1.25rem;
        margin: 0.5rem 1rem;
        border-radius: 0.75rem;
        color: #1e293b !important;
        font-weight: 600 !important;
        text-decoration: none !important;
        white-space: nowrap;
        transition: background 0.2s ease;
        background: transparent;
    }

    .nav-link:hover {
        background-color: rgba(100, 116, 139, 0.1);
    }

    .nav-link .icon {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 2.25rem;
        width: 2.25rem;
        margin-right: 0.85rem;
        border-radius: 0.5rem;
        font-size: 1.15rem;
        flex-shrink: 0;
        position: relative;
    }

    .nav-link span {
        font-size: 1rem;
        font-weight: 600 !important;
        flex-grow: 1;
        white-space: nowrap;
    }
</style>