<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// session_start();
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$success = $error = "";

// Fetch available wallets
$wallets = [];
$wallet_query = mysqli_query($conn, "SELECT * FROM wallet");
while ($row = mysqli_fetch_assoc($wallet_query)) {
    $wallets[$row['wallet_type']] = $row['wallet_address'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userid = $_SESSION['userid'];
    $amount = floatval($_POST['amount']);
    $wallet_type = mysqli_real_escape_string($conn, $_POST['wallet_type']);
    $wallet_address = mysqli_real_escape_string($conn, $_POST['wallet_address']);
    $transaction_id = mysqli_real_escape_string($conn, $_POST['transaction_id']);

    if ($amount > 0 && $wallet_type && $wallet_address && $transaction_id) {
        $stmt = $conn->prepare("INSERT INTO deposit (userid, amount, wallet_type, wallet_address_input, transaction_id, status, created_at)
        VALUES (?, ?, ?, ?, ?, 'pending', NOW())");
        
        $stmt->bind_param("sdsss", $userid, $amount, $wallet_type, $wallet_address, $transaction_id);

        if ($stmt->execute()) {
            $success = "✅ Deposit initiated. Our team will verify your transaction.";
        } else {
            $error = "❌ Failed to process deposit. Please try again.";
        }
        $stmt->close();
    } else {
        $error = "❌ Please fill in all required fields.";
    }
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    .deposit-card {
        background: #fff;
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
    }

    .deposit-card:hover {
        transform: translateY(-4px);
    }

    .btn-gradient {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        font-weight: 600;
    }

    .btn-gradient:hover {
        filter: brightness(1.1);
    }

    .form-control {
        border-radius: 50px;
        padding-left: 20px;
        padding-right: 20px;
    }

    body {
        background: #f4f6fa;
    }

    label {
        font-weight: 500;
    }
</style>
<style>
    .btn-copy {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: #fff;
        border: none;
        transition: 0.3s ease-in-out;
    }

    .btn-copy:hover {
        opacity: 0.9;
        transform: scale(1.05);
    }
</style>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-7">

            <div class="text-center mb-5">
                <h2 class="fw-bold text-white">💳 Deposit Funds</h2>
                <p class="text-white">Send crypto to our wallet and submit your transaction ID for confirmation.</p>
            </div>

            <?php if ($success) : ?>
                <div class="alert alert-success text-center shadow-sm"><?php echo $success; ?></div>
            <?php elseif ($error) : ?>
                <div class="alert alert-danger text-center shadow-sm"><?php echo $error; ?></div>
            <?php endif; ?>

            <div class="card deposit-card p-4">
                <form method="POST" class="row g-4">
                    <div class="col-12">
                        <label class="form-label">Deposit Amount (USD)</label>
                        <input type="number" name="amount" step="0.01" min="1" class="form-control form-control-lg" placeholder="e.g. 150.00" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Wallet Type</label>
                        <select name="wallet_type" id="wallet_type" class="form-control" required onchange="updateWalletAddress()">
                            <option value="" disabled selected>Select wallet type</option>
                            <?php foreach ($wallets as $type => $address) : ?>
                                <option value="<?php echo htmlspecialchars($type); ?>"><?php echo htmlspecialchars($type); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Wallet Address</label>
                        <div class="input-group">
                            <input type="text" name="wallet_address" id="wallet_address" class="form-control" readonly required>
                            <button type="button" class="btn btn-copy" onclick="copyWalletAddress()" title="Copy to clipboard">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                    </div>


                    <div class="col-12">
                        <label class="form-label">Transaction ID</label>
                        <input type="text" name="transaction_id" class="form-control" placeholder="Paste your transaction ID here" required>
                    </div>

                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-lg btn-gradient rounded-pill px-5">
                            <i class="fas fa-check-circle me-2"></i> Submit Deposit
                        </button>
                    </div>
                </form>
            </div>

            <div class="text-center mt-4">
                <a href="dashboard.php" class="text-muted text-decoration-none small">
                    <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</div>


<script>
    const wallets = <?php echo json_encode($wallets); ?>;

    function updateWalletAddress() {
        const type = document.getElementById("wallet_type").value;
        document.getElementById("wallet_address").value = wallets[type] || '';
    }

    function copyWalletAddress() {
        const input = document.getElementById("wallet_address");
        input.select();
        input.setSelectionRange(0, 99999); // For mobile
        document.execCommand("copy");

        // Optional: show visual feedback
        alert("Wallet address copied to clipboard!");
    }
</script>

<?php include "footer.php"; ?>