<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";
?>


<!-- cards -->
<div class="w-full px-6 py-6 mx-auto">
  <!-- row 1 -->
  <div class="flex flex-wrap -mx-3">
    <!-- Account Balance -->
    <div class="w-full max-w-full px-3 mb-6 sm:w-1/2 sm:flex-none xl:mb-0 xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60">Account Balance</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['account_balance'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-blue-500 to-violet-500">
                <i class="ni ni-money-coins text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Total Bonus -->
    <div class="w-full max-w-full px-3 mb-6 sm:w-1/2 sm:flex-none xl:mb-0 xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60">Sales Balance</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['total_bonus'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-red-600 to-orange-600">
                <i class="ni ni-world text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Profit Balance -->
    <div class="w-full max-w-full px-3 mb-6 sm:w-1/2 sm:flex-none xl:mb-0 xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60">Profit Balance</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['profit_balance'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-emerald-500 to-teal-400">
                <i class="ni ni-paper-diploma text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Total Withdrawal -->
    <div class="w-full max-w-full px-3 sm:w-1/2 sm:flex-none xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60">Total Withdrawal</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['total_withdrawal'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-orange-500 to-yellow-500">
                <i class="ni ni-cart text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- cards row 2 -->
  <div class="custom-footer"></div>

  <div class="flex flex-wrap mt-6 -mx-3">
    <!-- Profit Overview Chart -->
    <div class="w-full max-w-full px-3 mt-0 lg:w-7/12 lg:flex-none">
      <div class="h-80 shadow-xl relative z-20 flex flex-col rounded-2xl bg-white overflow-hidden">
        <div class="p-4 border-b">
          <h6 class="text-lg font-semibold text-gray-700">📈 Profit Overview</h6>
          <p class="text-sm text-gray-500">Live view of your profit growth</p>
        </div>
        <div class="flex-auto p-3">
          <canvas id="profitChart" class="w-full h-full"></canvas>
        </div>
      </div>
    </div>



    <div class="w-full max-w-full px-3 lg:w-5/12 lg:flex-none">
      <div slider class="relative w-full h-full overflow-hidden rounded-2xl">
        <!-- slide 1 -->
        <!-- Slide 1 - Digital Presence -->
        <div slide class="absolute w-full h-full transition-all duration-500">
          <img class="object-cover h-full" src="./assets/img/carousel-1.jpg" alt="carousel image" />
          <div class="block text-start ml-12 left-0 bottom-0 absolute right-[15%] pt-5 pb-5 text-white">
            <div class="inline-block w-8 h-8 mb-4 text-center text-black bg-white bg-center rounded-lg fill-current stroke-none">
              <i class="top-0.75 text-xxs relative text-slate-700 ni ni-spaceship"></i>
            </div>
            <h5 class="mb-1 text-white">Launch Your Digital Success</h5>
            <p class="dark:opacity-80">Start your journey with ChoicyDigitals — where we turn ideas into high-converting digital campaigns and brand experiences.</p>
          </div>
        </div>


        <!-- slide 2 -->
        <!-- Slide 2 - Digital Marketing Strategy -->
        <div slide class="absolute w-full h-full transition-all duration-500">
          <img class="object-cover h-full" src="./assets/img/carousel-2.jpg" alt="carousel image" />
          <div class="block text-start ml-12 left-0 bottom-0 absolute right-[15%] pt-5 pb-5 text-white">
            <div class="inline-block w-8 h-8 mb-4 text-center text-black bg-white bg-center rounded-lg fill-current stroke-none">
              <i class="top-0.75 text-xxs relative text-slate-700 ni ni-world-2"></i>
            </div>
            <h5 class="mb-1 text-white">Grow Your Brand Online</h5>
            <p class="dark:opacity-80">We create powerful digital marketing strategies that drive traffic, leads, and real results for your business.</p>
          </div>
        </div>

        <!-- Slide 3 - Social Media & Campaigns -->
        <div slide class="absolute w-full h-full transition-all duration-500">
          <img class="object-cover h-full" src="./assets/img/carousel-3.jpg" alt="carousel image" />
          <div class="block text-start ml-12 left-0 bottom-0 absolute right-[15%] pt-5 pb-5 text-white">
            <div class="inline-block w-8 h-8 mb-4 text-center text-black bg-white bg-center rounded-lg fill-current stroke-none">
              <i class="top-0.75 text-xxs relative text-slate-700 ni ni-chat-round"></i>
            </div>
            <h5 class="mb-1 text-white">Engage. Convert. Retain.</h5>
            <p class="dark:opacity-80">From social media to email campaigns, we help you connect with your audience and build lasting relationships.</p>
          </div>
        </div>

        <!-- Control buttons -->
        <button btn-next class="absolute z-10 w-10 h-10 p-2 text-lg text-white border-none opacity-50 cursor-pointer hover:opacity-100 far fa-chevron-right active:scale-110 top-6 right-4"></button>
        <button btn-prev class="absolute z-10 w-10 h-10 p-2 text-lg text-white border-none opacity-50 cursor-pointer hover:opacity-100 far fa-chevron-left active:scale-110 top-6 right-16"></button>
      </div>
    </div>
  </div>

  <!-- cards row 3 -->

  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const ctx = document.getElementById("profitChart").getContext("2d");

      const profitBalance = <?php echo $user['profit_balance']; ?>;

      const chart = new Chart(ctx, {
        type: "line",
        data: {
          labels: ["", "", "", "", "", ""],
          datasets: [{
            label: "Profit Balance",
            data: [
              0,
              profitBalance * 0.2,
              profitBalance * 0.4,
              profitBalance * 0.6,
              profitBalance * 0.8,
              profitBalance
            ],
            backgroundColor: "rgba(72, 187, 120, 0.15)",
            borderColor: "#48bb78",
            fill: true,
            tension: 0.4,
            borderWidth: 3,
            pointRadius: 3,
            pointBackgroundColor: "#48bb78"
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: {
              display: false
            },
            tooltip: {
              callbacks: {
                label: context => "$" + context.parsed.y.toFixed(2)
              }
            }
          },
          scales: {
            x: {
              display: false
            },
            y: {
              beginAtZero: true,
              ticks: {
                callback: value => "$" + value,
                color: "#666",
                font: {
                  size: 12
                }
              }
            }
          }
        }
      });
    });
  </script>

  <?php
  include "footer.php";
  ?>