<?php
include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$selected_product_id = $_GET['product_id'] ?? '';
$feedback = '';

// Fetch all products this user owns with admin messages
$products_with_admin_chat = $conn->prepare("
    SELECT DISTINCT p.product_id, p.product_name 
    FROM products p
    INNER JOIN product_messages pm ON pm.product_id = p.product_id
    WHERE p.user_id = ? AND pm.sender_role = 'admin'
");
$products_with_admin_chat->bind_param("s", $userid);
$products_with_admin_chat->execute();
$products_result = $products_with_admin_chat->get_result();

// Handle message reply from user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['product_id'], $_POST['message'])) {
    $product_id = $_POST['product_id'];
    $message = trim($_POST['message']);
    $image_name = "";

    if (!empty($_FILES['image']['name'])) {
        $upload_dir = "uploads/";
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
        $image_name = time() . "_" . basename($_FILES["image"]["name"]);
        move_uploaded_file($_FILES["image"]["tmp_name"], $upload_dir . $image_name);
    }

    $stmt = $conn->prepare("INSERT INTO product_messages (product_id, sender_role, sender_id, receiver_id, message, image, seen, sent_at) VALUES (?, 'user', ?, 'admin', ?, ?, 0, NOW())");
    $stmt->bind_param("sssss", $product_id, $userid, $message, $image_name);

    if ($stmt->execute()) {
        $feedback = '<div class="alert alert-success">Message sent successfully.</div>';
    } else {
        $feedback = '<div class="alert alert-danger">Failed to send message.</div>';
    }
}

// Mark messages as seen when product is opened
if (!empty($selected_product_id)) {
    $mark_seen = $conn->prepare("
        UPDATE product_messages 
        SET seen = 1 
        WHERE product_id = ? 
          AND sender_role = 'admin' 
          AND receiver_id = ? 
          AND seen = 0
    ");
    $mark_seen->bind_param("ss", $selected_product_id, $userid);
    $mark_seen->execute();
}

// Load chat for selected product
$chat_result = [];
if (!empty($selected_product_id)) {
    $chat_query = $conn->prepare("
        SELECT * FROM product_messages
        WHERE product_id = ?
          AND (
              (sender_id = 'admin' AND receiver_id = ?) OR
              (sender_id = ? AND receiver_id = 'admin')
          )
        ORDER BY sent_at ASC
    ");
    $chat_query->bind_param("sss", $selected_product_id, $userid, $userid);
    $chat_query->execute();
    $chat_result = $chat_query->get_result();
}
?>

<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <div class="card">
                <div class="card-header bg-dark text-white fw-bold">Messages from Admin</div>
                <div class="card-body">

                    <form method="get" class="mb-3">
                        <label>Select Product</label>
                        <select name="product_id" class="form-select" onchange="this.form.submit()" required>
                            <option value="">-- Choose Product --</option>
                            <?php while ($prod = $products_result->fetch_assoc()) : ?>
                                <option value="<?php echo $prod['product_id']; ?>" <?php echo ($selected_product_id === $prod['product_id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($prod['product_name']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </form>

                    <?php echo $feedback; ?>

                    <?php if (!empty($selected_product_id)) : ?>
                        <div class="chat-box mb-4" style="height:400px; overflow-y:auto; background:#f4f4f4; padding:10px; border-radius:8px;">
                            <?php while ($msg = $chat_result->fetch_assoc()) : ?>
                                <div class="<?php echo $msg['sender_role'] === 'admin' ? 'text-start' : 'text-end'; ?>">
                                    <div class="p-2 my-1" style="background-color:<?php echo $msg['sender_role'] === 'admin' ? '#ffffff' : '#dcf8c6'; ?>; border-radius:10px; display:inline-block;">
                                        <?php echo nl2br(htmlspecialchars($msg['message'])); ?>
                                        <?php if ($msg['image']) : ?>
                                            <br><img src="uploads/<?php echo $msg['image']; ?>" style="max-width:200px; border-radius:8px;">
                                        <?php endif; ?>
                                        <div class="small text-muted"><?php echo date("M d, Y h:i A", strtotime($msg['sent_at'])); ?></div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>

                        <form method="POST" enctype="multipart/form-data" class="border p-3 rounded bg-light">
                            <input type="hidden" name="product_id" value="<?php echo $selected_product_id; ?>">
                            <div class="mb-3">
                                <label class="form-label">Reply</label>
                                <textarea name="message" class="form-control" rows="3" required></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Optional Image</label>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <button class="btn btn-primary">Send</button>
                        </form>
                    <?php else : ?>
                        <div class="alert alert-info">Select a product to view messages.</div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </section>
</div>

<?php include 'footer.php'; ?>
