<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];

// Ensure product_id is provided
if (!isset($_GET['product_id'])) {
    die("<div class='alert alert-danger m-4'>❌ Product ID not provided.</div>");
}

$product_id = $_GET['product_id'];

// Fetch product details
$stmt = $conn->prepare("SELECT product_name, image FROM products WHERE product_id = ?");
$stmt->bind_param("s", $product_id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {
    die("<div class='alert alert-danger m-4'>❌ Product not found.</div>");
}

// Fetch sales
$salesStmt = $conn->prepare("SELECT sale_amount, sale_date FROM product_sales WHERE product_id = ? AND userid = ? ORDER BY sale_date ASC");
$salesStmt->bind_param("ss", $product_id, $userid);
$salesStmt->execute();
$salesResult = $salesStmt->get_result();

$sales_dates = [];
$sales_amounts = [];
$cumulative_amounts = [];
$total_sales = 0;

while ($sale = $salesResult->fetch_assoc()) {
    $sales_dates[] = date("M d", strtotime($sale['sale_date']));
    $sales_amounts[] = $sale['sale_amount'];
    $total_sales += $sale['sale_amount'];
    $cumulative_amounts[] = $total_sales; // Add cumulative total for chart
}

// Handle export
if (isset($_GET['export']) && in_array($_GET['export'], ['csv', 'excel'])) {
    $filename = "sales_report_" . $product_id . "." . ($_GET['export'] === 'csv' ? 'csv' : 'xls');
    header("Content-Disposition: attachment; filename=$filename");
    header("Content-Type: application/vnd.ms-excel");
    echo "Sale Amount, Sale Date\n";
    $salesStmt->execute();
    $exportRes = $salesStmt->get_result();
    while ($row = $exportRes->fetch_assoc()) {
        echo $row['sale_amount'] . "," . date("Y-m-d H:i:s", strtotime($row['sale_date'])) . "\n";
    }
    exit;
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
body { background: #f9fafc; }
.sales-table { background: #fff; border-radius: 16px; box-shadow: 0 8px 25px rgba(0, 0, 0, 0.05); overflow: hidden; }
.table thead { background-color: #f4f6f8; font-weight: 600; color: #333; }
.table td, .table th { vertical-align: middle; }
.product-img { width: 60px; height: 60px; object-fit: cover; border-radius: 8px; }
.total-card { background: #28a745; color: white; padding: 15px 20px; border-radius: 12px; font-size: 1.25rem; font-weight: 600; margin-bottom: 20px; }
</style>

<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-white">📊 Sales Report</h2>
        <a href="my_promotions.php" class="btn btn-sm btn-outline-secondary">← Back</a>
    </div>

    <div class="sales-table p-4 mb-4">
        <div class="d-flex align-items-center mb-3">
            <img src="./uploads/<?= htmlspecialchars($product['image']) ?>" class="product-img me-3" alt="">
            <h4 class="fw-bold mb-0"><?= htmlspecialchars($product['product_name']) ?></h4>
        </div>

        <!-- Total Sales -->
        <div class="total-card">
            💰 Total Trade Amount: $<?= number_format($total_sales, 2) ?>
        </div>

        <div class="d-flex justify-content-end mb-3">
            <a href="view_sales.php?product_id=<?= urlencode($product_id) ?>&export=csv" class="btn btn-sm btn-primary me-2">⬇ Export CSV</a>
            <a href="view_sales.php?product_id=<?= urlencode($product_id) ?>&export=excel" class="btn btn-sm btn-success">⬇ Export Excel</a>
        </div>

        <canvas id="salesChart" height="120"></canvas>

        <div class="table-responsive mt-4">
            <table class="table table-striped align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Sale Amount ($)</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $salesStmt->execute();
                    $salesResult = $salesStmt->get_result();
                    if ($salesResult->num_rows > 0) {
                        $count = 1;
                        while ($sale = $salesResult->fetch_assoc()) {
                            echo "<tr>
                                    <td>{$count}</td>
                                    <td>$" . number_format($sale['sale_amount'], 2) . "</td>
                                    <td>" . date("M d, Y h:i A", strtotime($sale['sale_date'])) . "</td>
                                  </tr>";
                            $count++;
                        }
                    } else {
                        echo "<tr><td colspan='3' class='text-center text-muted'>😕 No sales recorded yet.</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
const ctx = document.getElementById('salesChart').getContext('2d');
const salesChart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?= json_encode($sales_dates) ?>,
        datasets: [
            {
                label: 'Sale Amount ($)',
                data: <?= json_encode($sales_amounts) ?>,
                backgroundColor: 'rgba(37, 117, 252, 0.2)',
                borderColor: 'rgba(37, 117, 252, 1)',
                borderWidth: 2,
                fill: true,
                tension: 0.3,
                pointRadius: 5
            },
            {
                label: 'Cumulative Total ($)',
                data: <?= json_encode($cumulative_amounts) ?>,
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                borderColor: 'rgba(40, 167, 69, 1)',
                borderWidth: 2,
                fill: false,
                tension: 0.3,
                pointRadius: 5
            }
        ]
    },
    options: {
        responsive: true,
        plugins: {
            tooltip: { mode: 'index', intersect: false }
        },
        scales: {
            x: { title: { display: true, text: 'Date' } },
            y: { title: { display: true, text: 'Amount ($)' }, beginAtZero: true }
        }
    }
});
</script>

<?php include "footer.php"; ?>
