<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include "../_db.php";

session_start();

$userid = $_SESSION['userid'];
$product_id = $_POST['product_id'] ?? '';
$promotion_fee = $_POST['promotion_fee'] ?? '';
$payment_method = $_POST['payment_method'] ?? '';

if (empty($product_id) || empty($promotion_fee) || empty($payment_method) || !isset($_FILES['payment_proof'])) {
    $_SESSION['flash_message'] = [
        'type' => 'danger',
        'text' => 'All fields and payment proof are required for promotion.'
    ];
    header("Location: promote_product.php");
    exit();
}

// Validate product exists and is promotable
$stmt = $conn->prepare("SELECT * FROM products WHERE product_id = ?");
$stmt->bind_param("s", $product_id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {
    $_SESSION['flash_message'] = [
        'type' => 'warning',
        'text' => 'Product not eligible for promotion.'
    ];
    header("Location: promote_product.php");
    exit();
}

// Handle payment proof upload
$upload_dir = "../uploads/promotions/";
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

$proof_tmp = $_FILES['payment_proof']['tmp_name'];
$proof_name = basename($_FILES['payment_proof']['name']);
$proof_ext = strtolower(pathinfo($proof_name, PATHINFO_EXTENSION));
$allowed_ext = ['jpg', 'jpeg', 'png', 'pdf'];

if (!in_array($proof_ext, $allowed_ext)) {
    $_SESSION['flash_message'] = [
        'type' => 'danger',
        'text' => 'Invalid file type for payment proof. Only JPG, PNG, and PDF allowed.'
    ];
    header("Location: promote_product.php");
    exit();
}

$new_filename = uniqid('proof_') . '.' . $proof_ext;
$destination = $upload_dir . $new_filename;

if (!move_uploaded_file($proof_tmp, $destination)) {
    $_SESSION['flash_message'] = [
        'type' => 'danger',
        'text' => 'Failed to upload payment proof.'
    ];      
        header("Location: promote_product.php?product_id=" . urlencode($product_id));
    exit();
}

// Save promotion record
$insert = $conn->prepare("INSERT INTO product_promotions (userid, product_id, promotion_fee, payment_method, payment_proof) VALUES (?, ?, ?, ?, ?)");
$insert->bind_param("ssdss", $userid, $product_id, $promotion_fee, $payment_method, $new_filename);

if ($insert->execute()) {
    $_SESSION['flash_message'] = [
        'type' => 'success',
        'text' => '🎉 Product successfully submitted for promotion!'
    ];
} else {
    $_SESSION['flash_message'] = [
        'type' => 'danger',
        'text' => '❌ Failed to process your promotion request.'
    ];
}

header("Location: promote_product.php?product_id=" . urlencode($product_id));
exit();
