<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

// Check if product_id is passed
if (!isset($_GET['product_id'])) {
    echo "<div class='container py-5'><div class='alert alert-danger'>Invalid request. No project selected.</div></div>";
    exit;
}

$product_id = mysqli_real_escape_string($conn, $_GET['product_id']);

// Fetch product from DB
$query = mysqli_query($conn, "SELECT * FROM products WHERE product_id = '$product_id' LIMIT 1");

if (mysqli_num_rows($query) == 0) {
    echo "<div class='container py-5'><div class='alert alert-warning'>Project not found.</div></div>";
    exit;
}

$product = mysqli_fetch_assoc($query);

?>
<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

<!-- Bootstrap JS (Optional, for modals, dropdowns, etc.) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-QZkq+DrIWZzPqNmgIG7K5Azqp9ul1+8F7tcbKpTxL+xQAgdk1DJjGyw+vbPzvC4f" crossorigin="anonymous"></script>
<!-- Page Design -->
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10 col-xl-9">
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                <div class="row g-0">
                    <?php if (isset($_GET['error'])) : ?>
                        <div class="alert alert-danger text-center">
                            <?php echo htmlspecialchars($_GET['error']); ?>
                        </div>
                    <?php elseif (isset($_GET['success'])) : ?>
                        <div class="alert alert-success text-center">
                            <?php echo htmlspecialchars($_GET['success']); ?>
                        </div>
                    <?php endif; ?>

                    <!-- Image Section -->
                    <div class="col-md-5 bg-dark d-flex align-items-center">
                        <img src="./uploads/<?php echo $product['image']; ?>" class="img-fluid w-100 h-100 object-fit-cover" alt="Project Image">
                    </div>

                    <!-- Info Section -->
                    <div class="col-md-7 bg-white p-5 d-flex flex-column justify-content-between">
                        <div>
                            <h3 class="fw-bold mb-3"><?php echo $product['product_name']; ?></h3>
                            <p class="text-muted small mb-4" style="line-height: 1.7;"><?php echo nl2br($product['description']); ?></p>
                        </div>

                        <div>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <span class="text-muted small">Price</span>
                                <span class="fs-4 fw-bold text-success">$<?php echo number_format($product['amount'], 2); ?></span>
                            </div>

                            <form action="confirm-purchase.php" method="POST">
                                <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>">
                                <input type="hidden" name="amount" value="<?php echo $product['amount']; ?>">
                                <button type="submit" class="btn btn-lg btn-gradient px-4 w-100 rounded-pill" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;">
                                    <i class="fas fa-check-circle me-2"></i> Confirm Purchase
                                </button>
                            </form>
                            <!-- Contact Buyer Button -->
                            <!-- Marquee Alert -->
                            <div class="alert mt-4 alert-warning rounded-pill shadow-sm text-center mb-4" style="background-color: #fff3cd; border-color: #ffeeba;">
                                <marquee behavior="scroll" direction="left" scrollamount="5" onmouseover="this.stop();" onmouseout="this.start();">
                                    <strong>Note:</strong> To communicate with buyers directly, kindly reach out to our support team for proper guidance and authorization. Thank you for your cooperation.
                                </marquee>
                            </div>


                            <!-- Back Link -->
                            <a href="projects.php" class="d-block text-center mt-2 text-decoration-none text-muted small">
                                <i class="fas fa-arrow-left me-1"></i> Back to Projects
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="foot"></div>
<style>
    .foot {
        min-height: 10px;
        /* Default footer height */
    }

    @media (min-width: 1024px) {
        .foot {
            min-height: 130px;
            /* Taller footer on large screens */
        }
    }
</style>
<?php include "footer.php"; ?>