<?php
require_once('../_db.php');

// Ensure request is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Invalid request method.');
}

// Validate input
$receiverId = $_POST['receiver_id'] ?? null;
$productId = $_POST['product_id'] ?? null;
$message = trim($_POST['message'] ?? '');

if (!$receiverId || !$productId || empty($message)) {
    http_response_code(400);
    exit('All fields are required.');
}

// Admin is the sender
$senderId = 'admin';

// Prepare and execute insert
$stmt = $conn->prepare("INSERT INTO messages (sender_id, receiver_id, product_id, message, created_at) VALUES (?, ?, ?, ?, NOW())");
$stmt->bind_param("ssis", $senderId, $receiverId, $productId, $message);

if ($stmt->execute()) {
    // Redirect back to the chat
    header("Location: admin-chat.php?user={$receiverId}&product={$productId}");
    exit;
} else {
    http_response_code(500);
    echo "Failed to send message. Please try again.";
}
?>
