   <?php 
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <?php 
        include 'sidebar.php';
        if (isset($message)) {
            foreach ($message as $message) {
                echo '<div class="message"><span>' . $message . '</span> <i class="fas fa-times" onclick="this.parentElement.style.display = `none`;"></i> </div>';
            };
        };
        ?>
        
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>
                <div class="container">
                   
                    <!-- DETAILS/DELETE MODAL -->
                    <div class=""> 
                    <?php
                    // Assuming you have a database connection established
                    if (isset($_GET['product_id'])) {
                        $product_id = $_GET['product_id'];

                        // Fetch product data from the database based on the provided product_id
                        $query = "SELECT * FROM products WHERE product_id = ?";
                        
                        if ($stmt = $conn->prepare($query)) {
                            $stmt->bind_param("s", $product_id);
                            
                            if ($stmt->execute()) {
                                $result = $stmt->get_result();

                                // Check if there are rows in the result set
                                if ($result->num_rows > 0) {
                                    $row = $result->fetch_assoc();
?>

                <div class="text-right my-4">
                    <a href="#" data-toggle="modal" data-target="#myModal" class="btn btn-info"><i class="bi bi-pencil-square"></i> Edit</a>
                    <a href="delete-rental.php?delete=<?php echo $row['product_id']; ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this?');"><i class="bi bi-trash3-fill"></i> Delete</a>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h3>Manage Rental Details</h3>
                    </div> 
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <img src="../uploads/products/<?php echo $row['image']; ?>" class="img-fluid" height="700" alt="">
                            </div>
                            
                            <div class="col-md-6">
                                <h2>Product Name:</h2>
                                <p><?php echo html_entity_decode($row['product_name']); ?></p>
                            
                                <h2>Price:</h2>
                                <p>$<?php echo number_format($row['amount']); ?></p>
                                
                                <h2>Description:</h2>
                                <p><?php echo html_entity_decode($row['description']); ?></p>
                            </div>
                        </div>  
                    </div>                            
                </div>

                <!-- The Modal -->
                <div class="modal fade" id="myModal">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
              
                            <!-- Modal Header -->
                            <div class="modal-header">
                                <h4 class="modal-title">Manage Services</h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                            </div>
                
                            <!-- Modal body -->
                            <div class="modal-body">
                                <form action="manage-rental-process.php" method="post" enctype="multipart/form-data">

                                    <!-- Hidden input field to store the rental ID -->
                                    <input type="hidden" name="product_id" value="<?php echo $row['product_id']; ?>">

                                    <div class="form-group">
                                        <input type="text" name="bedrooms" placeholder="Enter bedrooms" class="form-control my-2" required value="<?php echo $row['product_name']; ?>">
                                    </div>

                                    <div class="form-group">
                                        <input type="text" name="price" placeholder="Enter price" class="form-control my-2" value="<?php echo $row['amount']; ?>" required>
                                    </div>

                                    <div class="form-group">
                                        <textarea name="description" placeholder="Enter description" class="form-control my-2" required><?php echo $row['description']; ?></textarea>
                                    </div>
                  
                                    <div class="form-group">
                                        <input type="file" name="images" accept="image/png, image/jpeg, image/jpg" class="form-control-file box">
                                        <small class="form-text text-muted">Current Image: <?php echo $row['images']; ?></small>
                                    </div>
                  
                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="submit" name="update_rental" class="btn btn-success">Update</button>
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div> 
                </div> 
            </div>
            <?php 
            } else {
                echo "No product found for the provided product_id.";
            }

            // Close the result set
            $result->close();
        } else {
            echo "Error executing the query: " . $stmt->error;
        }

        // Close the prepared statement
        $stmt->close();
    } else {
        echo "Error preparing the query: " . $conn->error;
    }
} else {
    echo "No product_id provided in the URL.";
}
 ?>
    <?php
    include 'footer.php';
    ?>
