<?php
include_once("../_db.php");

// Check if 'delete' GET parameter is provided
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);

    // Fetch the image filename first
    $stmt = $conn->prepare("SELECT image FROM products WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->bind_result($image);
    $stmt->fetch();
    $stmt->close();

    if ($image) {
        // Delete image file from server
        $imagePath = '../dashboard/uploads/' . $image;
        if (file_exists($imagePath)) {
            unlink($imagePath);
        }

        // Now delete the product from the database
        $deleteStmt = $conn->prepare("DELETE FROM products WHERE id = ?");
        $deleteStmt->bind_param("i", $id);

        if ($deleteStmt->execute()) {
            $deleteStmt->close();
            header("Location: create-products.php?status=deleted");
            exit();
        } else {
            echo "❌ Failed to delete product: " . $deleteStmt->error;
        }
    } else {
        echo "❌ Product not found.";
    }
} else {
    echo "❌ Invalid request.";
}
?>
