<?php
include 'head.php';

$product_id = $_GET['product_id'];

$stmt = $conn->prepare("SELECT * FROM product_messages WHERE product_id = ? ORDER BY sent_at ASC");
$stmt->bind_param("s", $product_id);
$stmt->execute();
$messages = $stmt->get_result();

while ($msg = $messages->fetch_assoc()) {
    $isAdmin = $msg['sender_role'] === 'admin';
    $side = $isAdmin ? 'chat-right' : 'chat-left';
    $bubble = $isAdmin ? 'admin-message' : 'seller-message';

    echo '<div class="' . $side . '">
            <div class="chat-message shadow-sm ' . $bubble . '">';
    if (!empty($msg['message'])) {
        echo nl2br(htmlspecialchars($msg['message']));
    }
    if (!empty($msg['image'])) {
        echo '<img src="../dashboard/uploads/' . htmlspecialchars($msg['image']) . '" class="chat-image" alt="Image">';
    }
    echo '<div class="time">' . date("M d, Y h:i A", strtotime($msg['sent_at'])) . '</div>
        </div>
    </div>';
}
