<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $product_id  = $_POST['product_id'];
    $user_id     = $_POST['user_id'];
    $sale_amount = $_POST['sale_amount'];

    if (!empty($product_id) && !empty($user_id) && !empty($sale_amount)) {
        $stmt = $conn->prepare("INSERT INTO product_sales (product_id, userid, sale_amount, sale_date, added_by) VALUES (?, ?, ?, NOW(), 'admin')");
        $stmt->bind_param("ssd", $product_id, $user_id, $sale_amount);

        if ($stmt->execute()) {
            $feedback = '<div class="alert alert-success">✅ Sale added successfully.</div>';
        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to add sale. Please try again.</div>';
        }
    } else {
        $feedback = '<div class="alert alert-warning">⚠️ Please fill in all fields.</div>';
    }
}

// Fetch users and their autopilot products
$query = "
    SELECT DISTINCT u.userid, u.full_name, p.product_id, pr.product_name
    FROM product_promotions pp
    INNER JOIN user_login u ON pp.userid = u.userid
    INNER JOIN products pr ON pp.product_id = pr.product_id
    INNER JOIN products p ON pr.product_id = p.product_id
    WHERE pp.autopilot = 1
    ORDER BY u.full_name ASC, pr.product_name ASC
";
$result = $conn->query($query);

// Organize users and products
$user_products = [];
while ($row = $result->fetch_assoc()) {
    $user_products[$row['userid']]['name'] = $row['full_name'];
    $user_products[$row['userid']]['products'][] = [
        'product_id'   => $row['product_id'],
        'product_name' => $row['product_name']
    ];
}

// Handle CSV export
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=sales_report.csv');
    $output = fopen('php://output', 'w');
    fputcsv($output, ['User ID', 'Full Name', 'Product Name', 'Sale Amount', 'Sale Date']);

    $sales = $conn->query("
        SELECT s.userid, u.full_name, p.product_name, s.sale_amount, s.sale_date
        FROM product_sales s
        INNER JOIN user_login u ON s.userid = u.userid
        INNER JOIN products p ON s.product_id = p.product_id
        ORDER BY s.sale_date DESC
    ");

    while ($row = $sales->fetch_assoc()) {
        fputcsv($output, $row);
    }
    fclose($output);
    exit();
}
?>

<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="fw-bold">Add Sales for Autopilot Products</h4>
                <a href="?export=csv" class="btn btn-sm btn-primary">⬇ Export Sales (CSV)</a>
            </div>

            <?php echo $feedback; ?>

            <div class="card">
                <div class="card-header bg-primary text-white fw-bold">
                    Add Sale
                </div>
                <div class="card-body">
                    <form method="POST" class="row g-3">
                        <div class="col-md-6">
                            <label for="user_id" class="form-label">Select User</label>
                            <select name="user_id" id="user_id" class="form-select" required onchange="filterProducts(this.value)">
                                <option value="">-- Choose User --</option>
                                <?php foreach ($user_products as $uid => $data): ?>
                                    <option value="<?php echo $uid; ?>">
                                        <?php echo htmlspecialchars($data['name']); ?> (#<?php echo $uid; ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label for="product_id" class="form-label">Select Product</label>
                            <select name="product_id" id="product_id" class="form-select" required>
                                <option value="">-- Select User First --</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label for="sale_amount" class="form-label">Sale Amount ($)</label>
                            <input type="number" step="0.01" name="sale_amount" id="sale_amount" class="form-control" required>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-success">💾 Save Sale</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </section>
</div>

<script>
    const userProducts = <?php echo json_encode($user_products); ?>;

    function filterProducts(userId) {
        const productSelect = document.getElementById('product_id');
        productSelect.innerHTML = '<option value="">-- Choose Product --</option>';

        if (userId && userProducts[userId]) {
            userProducts[userId]['products'].forEach(prod => {
                let opt = document.createElement('option');
                opt.value = prod.product_id;
                opt.textContent = prod.product_name;
                productSelect.appendChild(opt);
            });
        }
    }
</script>

<?php include 'footer.php'; ?>
