<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";
// Handle approval or deletion
if (isset($_POST['action']) && isset($_POST['deposit_id'])) {
    $deposit_id = $_POST['deposit_id'];
    $action = $_POST['action'];

    if ($action === 'approve') {
        // Fetch deposit details
        $stmt = $conn->prepare("SELECT userid, product_id, promotion_fee, created_at FROM product_promotions WHERE id = ?");
        $stmt->bind_param("i", $deposit_id);
        $stmt->execute();
        $deposit = $stmt->get_result()->fetch_assoc();

        if ($deposit) {
            // Insert into product_sales
            $saleStmt = $conn->prepare("INSERT INTO product_sales (product_id, userid, sale_amount, sale_date, added_by) VALUES (?, ?, ?, ?, 'admin')");
            $saleStmt->bind_param("ssds", $deposit['product_id'], $deposit['userid'], $deposit['promotion_fee'], $deposit['created_at']);
            if ($saleStmt->execute()) {
                // Update deposit status to approved
                $updateStmt = $conn->prepare("UPDATE product_promotions SET status = 'approved' WHERE id = ?");
                $updateStmt->bind_param("i", $deposit_id);
                $updateStmt->execute();

                $feedback = '<div class="alert alert-success">✅ Deposit approved successfully.</div>';
            } else {
                $feedback = '<div class="alert alert-danger">❌ Failed to add to sales.</div>';
            }
        } else {
            $feedback = '<div class="alert alert-danger">❌ Deposit not found.</div>';
        }
    } elseif ($action === 'delete') {
        // Delete the autopilot deposit
        $stmt = $conn->prepare("DELETE FROM product_promotions WHERE id = ?");
        $stmt->bind_param("i", $deposit_id);
        if ($stmt->execute()) {
            $feedback = '<div class="alert alert-success">✅ Deposit deleted successfully.</div>';
        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to delete deposit.</div>';
        }
    }
}

// Fetch all pending autopilot deposits
$query = "
    SELECT pp.id, u.userid, u.full_name, p.product_id, p.product_name, pp.promotion_fee, pp.status, pp.created_at
    FROM product_promotions pp
    INNER JOIN user_login u ON pp.userid = u.userid
    INNER JOIN products p ON pp.product_id = p.product_id
    WHERE pp.autopilot = 1 AND pp.status = 'pending'
    ORDER BY pp.created_at DESC
";
$result = $conn->query($query);
?>

<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <h4 class="fw-bold mb-3">✅ Approve or Delete Autopilot Deposits</h4>

            <?php echo $feedback; ?>

            <div class="card">
                <div class="card-header bg-primary text-white fw-bold">
                    Pending Autopilot Deposits
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>User</th>
                                <th>Product</th>
                                <th>Deposit Amount ($)</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if ($result->num_rows > 0) {
                                $count = 1;
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>
                                            <td>{$count}</td>
                                            <td>" . htmlspecialchars($row['full_name']) . " (#{$row['userid']})</td>
                                            <td>" . htmlspecialchars($row['product_name']) . "</td>
                                            <td>$" . number_format($row['promotion_fee'], 2) . "</td>
                                            <td>" . date("M d, Y h:i A", strtotime($row['created_at'])) . "</td>
                                            <td>
                                                <form method='POST' style='display:inline-block;'>
                                                    <input type='hidden' name='deposit_id' value='{$row['id']}'>
                                                    <button type='submit' name='action' value='approve' class='btn btn-sm btn-success'>Approve</button>
                                                </form>
                                                <form method='POST' style='display:inline-block;'>
                                                    <input type='hidden' name='deposit_id' value='{$row['id']}'>
                                                    <button type='submit' name='action' value='delete' class='btn btn-sm btn-danger'>Delete</button>
                                                </form>
                                            </td>
                                          </tr>";
                                    $count++;
                                }
                            } else {
                                echo "<tr><td colspan='6' class='text-center text-muted'>😕 No pending autopilot deposits.</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </section>
</div>

<?php include 'footer.php'; ?>
