<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$is_logged_in = isset($_SESSION['userid']);
$unreadCount = 0;

if ($is_logged_in) {
    $userid = $_SESSION['userid'];

    // ✅ Correct message count for user's products
    $sql = "SELECT COUNT(*) as total
            FROM product_messages pm
            JOIN products p ON pm.product_id = p.product_id
            WHERE p.user_id = ? AND pm.sender_role = 'admin'";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $userid);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $unreadCount = $row['total'];
}
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<aside class="fixed inset-y-0 flex-wrap items-center justify-between block w-full p-0 my-4 overflow-y-auto antialiased transition-transform duration-200 -translate-x-full bg-white border-0 shadow-xl dark:shadow-none dark:bg-slate-850 max-w-64 ease-nav-brand z-990 xl:ml-6 rounded-2xl xl:left-0 xl:translate-x-0" aria-expanded="false">
    <div class="h-19">
        <i class="absolute top-0 right-0 p-4 opacity-50 cursor-pointer fas fa-times dark:text-white text-slate-400 xl:hidden" sidenav-close></i>
        <a class="block px-8 py-6 text-sm font-semibold text-slate-700 dark:text-white whitespace-nowrap" href="dashboard.php">
            <img src="./assets/img/logo-ct-dark.png" class="inline max-h-8 dark:hidden" alt="logo" />
            <img src="./assets/img/logo-ct.png" class="hidden max-h-8 dark:inline" alt="logo" />
            <span class="ml-1">ChoicyDigitals Dashboard</span>
        </a>
    </div>

    <hr class="h-px bg-gradient-to-r from-transparent via-black/40 to-transparent dark:via-white" />

    <div class="items-center w-auto max-h-screen overflow-auto h-sidenav grow">
        <ul class="flex flex-col mb-0">

<li>
    <a href="dashboard.php" class="nav-link">
        <div class="icon text-blue-500"><i class="fas fa-tachometer-alt"></i></div>
        <span>Dashboard</span>
    </a>
</li>

<li>
    <a href="deposit.php" class="nav-link">
        <div class="icon text-green-500"><i class="fas fa-wallet"></i></div>
        <span>Fund Account</span>
    </a>
</li>

<li>
    <a href="promote_projects.php" class="nav-link">
        <div class="icon text-purple-500"><i class="fas fa-bullhorn"></i></div>
        <span>Promote Products</span>
    </a>
</li>

<li>
    <a href="projects.php" class="nav-link">
        <div class="icon text-indigo-500"><i class="fas fa-store"></i></div>
        <span>Market Place</span>
    </a>
</li>

<li>
    <a href="user_projects.php" class="nav-link">
        <div class="icon text-cyan-600"><i class="fas fa-folder-open"></i></div>
        <span>My Projects</span>
    </a>
</li>

<li>
    <a href="create-project.php" class="nav-link">
        <div class="icon text-cyan-500"><i class="fas fa-plus-circle"></i></div>
        <span>Create Projects</span>
    </a>
</li>

<li>
    <a href="withdraw.php" class="nav-link">
        <div class="icon text-red-500"><i class="fas fa-money-bill-wave"></i></div>
        <span>Withdrawal</span>
    </a>
</li>

<li>
    <a href="messages.php" class="nav-link">
        <div class="icon text-orange-500 position-relative">
            <i class="fas fa-envelope"></i>
            <?php if ($unreadCount > 0) : ?>
                <span style="position: absolute; top: -8px; right: -8px; background: red; color: white; font-size: 10px; padding: 2px 6px; border-radius: 50%;">
                    <?= $unreadCount; ?>
                </span>
            <?php endif; ?>
        </div>
        <span>Messages</span>
    </a>
</li>

<!-- Section header -->
<li class="mt-4">
    <h6 class="pl-6 text-xs font-bold uppercase opacity-60 dark:text-white">Account Pages</h6>
</li>

<li>
    <a href="my_promotions.php" class="nav-link">
        <div class="icon text-pink-500"><i class="fas fa-star"></i></div>
        <span>My Promotions</span>
    </a>
</li>
<li>
    <a href="request.php" class="nav-link">
        <div class="icon text-lime-500"><i class="fas fa-file-signature"></i></div>
        <span>Sales Request</span>
    </a>
</li>
<li>
    <a href="profit.php" class="nav-link">
        <div class="icon text-lime-600"><i class="fas fa-chart-line"></i></div>
        <span>Monitor Profit</span>
    </a>
</li>

<li>
    <a href="profile.php" class="nav-link">
        <div class="icon text-gray-700"><i class="fas fa-user-circle"></i></div>
        <span>Profile</span>
    </a>
</li>

<li>
    <a href="linkacccount.php" class="nav-link">
        <div class="icon text-gray-700"><i class="fas fa-share-alt"></i></div>
        <span>Social Media Links</span>
    </a>
</li>

<?php if ($is_logged_in) : ?>
    <li>
        <a href="logout.php" class="nav-link">
            <div class="icon text-orange-500"><i class="fas fa-sign-out-alt"></i></div>
            <span>Sign Out</span>
        </a>
    </li>
<?php else : ?>
    <li>
        <a href="./pages/sign-in.html" class="nav-link">
            <div class="icon text-blue-500"><i class="fas fa-sign-in-alt"></i></div>
            <span>Sign In</span>
        </a>
    </li>
<?php endif; ?>

            

        </ul>
    </div>
    <div style="background: linear-gradient(135deg, #7f5af0, #5f2eea); color: white; padding: 15px; border-radius: 12px; margin: 20px;">
                <h6 style="font-weight: bold; margin-bottom: 10px;">Need Help?</h6>
                <p style="font-size: 13px; margin-bottom: 15px;">Contact our team if you have questions or issues with your account.</p>
                <a href="mailto:choicydigitalmarketing@gmail.com?subject=Support Request" class="btn btn-light w-100  fw-bold">
                    <i class="fas fa-envelope me-2"></i> Email Support
                </a>
            </div>
</aside>

<style>
    .nav-link {
        display: flex !important;
        align-items: center;
        padding: 1rem 1.25rem;
        margin: 0.5rem 1rem;
        border-radius: 0.75rem;
        color: #1e293b !important;
        font-weight: 600 !important;
        text-decoration: none !important;
        white-space: nowrap;
        transition: background 0.2s ease;
        background: transparent;
    }

    .nav-link:hover {
        background-color: rgba(100, 116, 139, 0.1);
    }

    .nav-link .icon {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 2.25rem;
        width: 2.25rem;
        margin-right: 0.85rem;
        border-radius: 0.5rem;
        font-size: 1.15rem;
        flex-shrink: 0;
        position: relative;
    }

    .nav-link span {
        font-size: 1rem;
        font-weight: 600 !important;
        flex-grow: 1;
        white-space: nowrap;
    }
</style>