<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

// Fetch total commission for this user
$stmt = $conn->prepare("SELECT COALESCE(SUM(amount), 0) AS total_commission FROM commission WHERE user_id = ?");
$stmt->bind_param("s", $userid);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$total_commission = $data['total_commission'] ?? 0.00;

// Generate commission trend (simulated based on total_commission)
$commissionHistory = [];
$step = $total_commission / 6;
for ($i = 1; $i <= 6; $i++) {
    $commissionHistory[] = round($step * $i + rand(-3, 3), 2);
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<!-- cards -->
<div class="w-full px-6 py-6 mx-auto">
  <!-- row 1 -->
  <div class="flex flex-wrap -mx-3">
    <!-- Account Balance -->
    <div class="w-full max-w-full px-3 mb-6 sm:w-1/2 sm:flex-none xl:mb-0 xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                    <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60" style="white-space: nowrap;">Account Balance</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['account_balance'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-blue-500 to-violet-500">
                <i class="ni ni-money-coins text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Total Bonus -->
    <div class="w-full max-w-full px-3 mb-6 sm:w-1/2 sm:flex-none xl:mb-0 xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60" style="white-space: nowrap;">Sales Balance</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['total_bonus'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-red-600 to-orange-600">
                <i class="ni ni-world text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Profit Balance -->
    <div class="w-full max-w-full px-3 mb-6 sm:w-1/2 sm:flex-none xl:mb-0 xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60" style="white-space: nowrap;">
    Profit Balance
</p>

                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['profit_balance'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-emerald-500 to-teal-400">
                <i class="ni ni-paper-diploma text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Total Withdrawal -->
    <div class="w-full max-w-full px-3 sm:w-1/2 sm:flex-none xl:w-1/4">
      <div class="relative flex flex-col min-w-0 break-words bg-white shadow-xl dark:bg-slate-850 dark:shadow-dark-xl rounded-2xl bg-clip-border">
        <div class="flex-auto p-4">
          <div class="flex flex-row -mx-3">
            <div class="flex-none w-2/3 max-w-full px-3">
              <div>
                <p class="mb-0 font-sans text-sm font-semibold uppercase dark:text-white dark:opacity-60" style="white-space: nowrap;">Total Withdrawal</p>
                <h5 class="mb-2 font-bold dark:text-white">$<?php echo number_format($user['total_withdrawal'], 2); ?></h5>
              </div>
            </div>
            <div class="px-3 text-right basis-1/3">
              <div class="inline-block w-12 h-12 text-center rounded-circle bg-gradient-to-tl from-orange-500 to-yellow-500">
                <i class="ni ni-cart text-lg relative top-3.5 text-white"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- cards row 2 -->
  <div class="custom-footer"></div>

  <div class="flex flex-wrap mt-6 -mx-3">
    <!-- Profit Overview Chart -->
   <style>
    body {
        background: #f4f6fa;
        font-family: 'Segoe UI', sans-serif;
    }

    .chart-card {
        background: #fff;
        border-radius: 18px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.06);
        padding: 30px;
    }

    .commission-value {
        font-size: 2.3rem;
        font-weight: 600;
        color: #333;
    }

    .commission-label {
        color: #666;
        font-size: 14px;
    }

    .chart-container {
        width: 100%;
        height: auto;
        position: relative;
    }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 chart-card">
            <div class="text-center mb-4">
                <h4 class="fw-semibold">Your Commission Trend</h4>
                <p class="text-muted mb-0">Based on your total commission earnings</p>
            </div>

            <div class="chart-container">
                <canvas id="commissionChart"></canvas>
            </div>

            <div class="text-center mt-4">
                <div class="commission-value">$<?php echo number_format($total_commission, 2); ?></div>
                <div class="commission-label">Total Commission Earned</div>
            </div>
        </div>
    </div>
</div>

<script>
    const ctx = document.getElementById('commissionChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ["", "", "", "", "", ""],
            datasets: [{
                data: <?php echo json_encode($commissionHistory); ?>,
                fill: true,
                backgroundColor: 'rgba(102, 126, 234, 0.15)',
                borderColor: '#667eea',
                borderWidth: 3,
                pointRadius: 3,
                pointBackgroundColor: '#764ba2',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: { display: false },
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: (value) => '$' + value,
                        color: '#999',
                        font: { size: 12 }
                    }
                }
            },
            plugins: {
                legend: { display: false },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return "$" + context.parsed.y;
                        }
                    }
                }
            }
        }
    });
</script>



    <div class="w-full max-w-full px-3 lg:w-5/12 lg:flex-none">
      <div slider class="relative w-full h-full overflow-hidden rounded-2xl">
        <!-- slide 1 -->
        <!-- Slide 1 - Digital Presence -->
        <div slide class="absolute w-full h-full transition-all duration-500">
          <img class="object-cover h-full" src="./assets/img/carousel-1.jpg" alt="carousel image" />
          <div class="block text-start ml-12 left-0 bottom-0 absolute right-[15%] pt-5 pb-5 text-white">
            <div class="inline-block w-8 h-8 mb-4 text-center text-black bg-white bg-center rounded-lg fill-current stroke-none">
              <i class="top-0.75 text-xxs relative text-slate-700 ni ni-spaceship"></i>
            </div>
            <h5 class="mb-1 text-white">Launch Your Digital Success</h5>
            <p class="dark:opacity-80">Start your journey with ChoicyDigitals — where we turn ideas into high-converting digital campaigns and brand experiences.</p>
          </div>
        </div>


        <!-- slide 2 -->
        <!-- Slide 2 - Digital Marketing Strategy -->
        <div slide class="absolute w-full h-full transition-all duration-500">
          <img class="object-cover h-full" src="./assets/img/carousel-2.jpg" alt="carousel image" />
          <div class="block text-start ml-12 left-0 bottom-0 absolute right-[15%] pt-5 pb-5 text-white">
            <div class="inline-block w-8 h-8 mb-4 text-center text-black bg-white bg-center rounded-lg fill-current stroke-none">
              <i class="top-0.75 text-xxs relative text-slate-700 ni ni-world-2"></i>
            </div>
            <h5 class="mb-1 text-white">Grow Your Brand Online</h5>
            <p class="dark:opacity-80">We create powerful digital marketing strategies that drive traffic, leads, and real results for your business.</p>
          </div>
        </div>

        <!-- Slide 3 - Social Media & Campaigns -->
        <div slide class="absolute w-full h-full transition-all duration-500">
          <img class="object-cover h-full" src="./assets/img/carousel-3.jpg" alt="carousel image" />
          <div class="block text-start ml-12 left-0 bottom-0 absolute right-[15%] pt-5 pb-5 text-white">
            <div class="inline-block w-8 h-8 mb-4 text-center text-black bg-white bg-center rounded-lg fill-current stroke-none">
              <i class="top-0.75 text-xxs relative text-slate-700 ni ni-chat-round"></i>
            </div>
            <h5 class="mb-1 text-white">Engage. Convert. Retain.</h5>
            <p class="dark:opacity-80">From social media to email campaigns, we help you connect with your audience and build lasting relationships.</p>
          </div>
        </div>

        <!-- Control buttons -->
        <button btn-next class="absolute z-10 w-10 h-10 p-2 text-lg text-white border-none opacity-50 cursor-pointer hover:opacity-100 far fa-chevron-right active:scale-110 top-6 right-4"></button>
        <button btn-prev class="absolute z-10 w-10 h-10 p-2 text-lg text-white border-none opacity-50 cursor-pointer hover:opacity-100 far fa-chevron-left active:scale-110 top-6 right-16"></button>
      </div>
    </div>
  </div>

  <!-- cards row 3 -->

  
  <?php
  include "footer.php";
  ?>