<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$product_id = $_GET['product_id'] ?? null;

if (!$product_id) {
    echo "<div class='alert alert-danger text-center'>❌ Invalid product selected.</div>";
    exit();
}

$message = "";

// Fetch promotion fee from settings
$settings_res = $conn->query("SELECT promotion_fee FROM settings LIMIT 1");
$promotion_fee = ($settings_res && $settings_res->num_rows > 0) 
    ? $settings_res->fetch_assoc()['promotion_fee'] 
    : 0.00;

// Fetch wallet payment methods
$wallets = $conn->query("SELECT wallet_type, wallet_address FROM wallet");

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $payment_method = $_POST['payment_method'];
    $promotion_fee = $_POST['promotion_fee'];

    // Handle proof upload
    $proofFileName = null;
    if (!empty($_FILES['payment_proof']['name'])) {
        $targetDir = "./uploads/";
        $proofFileName = time() . "_" . basename($_FILES['payment_proof']['name']);
        $targetFilePath = $targetDir . $proofFileName;

        if (!move_uploaded_file($_FILES['payment_proof']['tmp_name'], $targetFilePath)) {
            $message = "<div class='alert alert-danger'>❌ Failed to upload proof of payment.</div>";
        }
    }

    if (!$message) {
        // ✅ Insert new promotion with status = 'pending'
        $stmt = $conn->prepare("
            INSERT INTO product_promotions 
                (userid, product_id, promotion_fee, payment_method, payment_proof, autopilot, status, created_at)
            VALUES (?, ?, ?, ?, ?, 1, 'pending', NOW())
        ");
        $stmt->bind_param("ssdss", $userid, $product_id, $promotion_fee, $payment_method, $proofFileName);

        if ($stmt->execute()) {
            $message = "<div class='alert alert-success'>✅ Autopilot request submitted! Please wait for admin approval.</div>";
        } else {
            $message = "<div class='alert alert-danger'>❌ Database error: " . $stmt->error . "</div>";
        }
        $stmt->close();
    }
}
?>


<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

<style>
    body { background: #f8f9fc; }
    .card-custom { border-radius: 20px; border: none; }
    .btn-gradient {
        background: linear-gradient(45deg, #6a11cb, #2575fc);
        color: #fff;
        transition: all 0.3s ease;
    }
    .btn-gradient:hover {
        opacity: 0.9;
        color: #fff;
    }
    .copy-icon {
        cursor: pointer;
        color: #2575fc;
        font-size: 1.2rem;
        margin-left: 10px;
    }
    .copy-icon:hover { color: #6a11cb; }
    .toast-custom {
        position: fixed;
        bottom: 20px;
        right: 20px;
        background: #2575fc;
        color: #fff;
        padding: 10px 20px;
        border-radius: 30px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.2);
        display: none;
        z-index: 2000;
    }
</style>

<div class="container py-5">
    <div class="text-center mb-4">
        <h2 class="fw-bold">🚀 Activate Autopilot</h2>
        <p class="text-muted">Pay the Activation fee and upload proof of payment to activate autopilot.</p>
    </div>

    <?= $message ?>

    <div class="card shadow card-custom p-4 mx-auto" style="max-width: 600px;">
        <form method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
            <div class="mb-3">
                <label class="form-label fw-semibold">Promotion Fee (USD)</label>
                <input type="number" step="0.01" name="promotion_fee" class="form-control" 
                       value="<?= htmlspecialchars($promotion_fee) ?>" readonly>
            </div>

            <div class="mb-3">
                <label class="form-label fw-semibold">Select Payment Method</label>
                <select name="payment_method" id="payment_method" class="form-select" required onchange="showWalletAddress()">
                    <option value="">-- Select Method --</option>
                    <?php while ($w = $wallets->fetch_assoc()) : ?>
                        <option value="<?= htmlspecialchars($w['wallet_type']) ?>" 
                                data-address="<?= htmlspecialchars($w['wallet_address']) ?>">
                            <?= htmlspecialchars($w['wallet_type']) ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="mb-3" id="walletAddressBox" style="display:none;">
                <label class="form-label fw-semibold">Wallet Address</label>
                <div class="input-group">
                    <input type="text" id="walletAddress" class="form-control" readonly>
                    <span class="input-group-text bg-white">
                        <i class="fa-solid fa-copy copy-icon" onclick="copyWallet()" title="Copy Address"></i>
                    </span>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label fw-semibold">Upload Proof of Payment</label>
                <input type="file" name="payment_proof" class="form-control" accept="image/*,application/pdf" required>
                <small class="text-muted">Upload receipt/screenshot of payment</small>
            </div>

            <div class="d-grid mt-4">
                <button type="submit" class="btn btn-gradient rounded-pill px-5 shadow">✅ Activate Autopilot</button>
            </div>
        </form>
    </div>

    <div class="text-center mt-4">
        <a href="my_promotions.php" class="text-decoration-none small text-primary">← Back to Products</a>
    </div>
</div>

<div class="toast-custom" id="toast">📋 Wallet address copied!</div>

<script>
function showWalletAddress() {
    const select = document.getElementById("payment_method");
    const option = select.options[select.selectedIndex];
    const address = option.getAttribute("data-address");
    const box = document.getElementById("walletAddressBox");
    const input = document.getElementById("walletAddress");

    if (address) {
        input.value = address;
        box.style.display = "block";
    } else {
        box.style.display = "none";
        input.value = "";
    }
}

function copyWallet() {
    const walletInput = document.getElementById("walletAddress");
    navigator.clipboard.writeText(walletInput.value).then(() => {
        const toast = document.getElementById("toast");
        toast.style.display = "block";
        setTimeout(() => { toast.style.display = "none"; }, 2000);
    });
}
</script>

<?php include "footer.php"; ?>
