<?php
session_start();
require_once("../_db.php");

function generateUserId() {
    return 'USR' . strtoupper(bin2hex(random_bytes(5)));
}

function sendWelcomeEmail($email, $full_name, $userid) {
    $verify_link = "https://choicydigitals.org/verify.php?userid=$userid";
    $subject = "Verify Your Account - Choicy Digital Marketing";

    $message = "<html><body>";
    $message .= "<h3>Hello $full_name,</h3>";
    $message .= "<p>Thanks for signing up! Click below to verify your account:</p>";
    $message .= "<p><a href='$verify_link' style='padding: 12px 20px; background: #28a745; color: #fff; text-decoration: none;'>Verify Account</a></p>";
    $message .= "<p>Choicy Digital Team</p></body></html>";

    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "From: Choicy Digital <noreply@choicydigitals.org>";

    return mail($email, $subject, $message, $headers);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone_number']);
    $password = $_POST['password'];
    $cpassword = $_POST['cpassword'];

    if (!$full_name || !$email || !$phone || !$password || !$cpassword) {
        header("Location: ../signup.php?status=error&message=" . urlencode("Please fill all fields."));
        exit;
    }

    if ($password !== $cpassword) {
        header("Location: ../signup.php?status=error&message=" . urlencode("Passwords do not match."));
        exit;
    }

    if (strlen($password) < 6) {
        header("Location: ../signup.php?status=error&message=" . urlencode("Password must be at least 6 characters."));
        exit;
    }

    // Check if email already exists
    $check = $conn->prepare("SELECT id FROM user_login WHERE email = ?");
    $check->bind_param("s", $email);
    $check->execute();
    $check->store_result();
    if ($check->num_rows > 0) {
        header("Location: ../signup.php?status=error&message=" . urlencode("Email already registered."));
        exit;
    }

    $userid = generateUserId();
    $hashed = password_hash($password, PASSWORD_DEFAULT);

    $stmt = $conn->prepare("INSERT INTO user_login 
        (userid, phone_number, full_name, email, password, total_bonus, profit_balance, account_balance, status, created_at)
        VALUES (?, ?, ?, ?, ?, 0.00, 0.00, 0.00, 'active', NOW())");

    $stmt->bind_param("sssss", $userid, $phone, $full_name, $email, $hashed);

    if ($stmt->execute()) {
        sendWelcomeEmail($email, $full_name, $userid);
        $_SESSION['userid'] = $userid;
        header("Location: ../signup.php?status=success&message=" . urlencode("Registration successful!"));
        exit;
    } else {
        header("Location: ../signup.php?status=error&message=" . urlencode("Registration failed. Please try again."));
        exit;
    }
} else {
    header("Location: ../signup.php");
    exit;
}
