<?php
require_once('../_db.php');

$userId = $_GET['user'] ?? null;
$productId = $_GET['product'] ?? null;

if ($userId && $productId) {
    $query = "SELECT message, sender_id, created_at, image FROM messages 
              WHERE (sender_id = ? OR receiver_id = ?) AND product_id = ? 
              ORDER BY created_at";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssi", $userId, $userId, $productId);
    $stmt->execute();
    $result = $stmt->get_result();

    $messages = [];
    while ($row = $result->fetch_assoc()) {
        $messages[] = [
            'message' => $row['message'],
            'image' => $row['image'] ? 'uploads/chat/' . $row['image'] : null, // adjust path if needed
            'isAdmin' => $row['sender_id'] == 'admin',
            'created_at' => date("M j, Y • g:i A", strtotime($row['created_at']))
        ];
    }

    echo json_encode(['messages' => $messages]);
}
?>
