<?php
include 'head.php';
include 'header.php';

$status = $message = '';

// Simulate admin user ID (you can replace this with session-based or dropdown)
$admin_user_id = 'admin-001';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_name = trim($_POST['product_name']);
    $amount = trim($_POST['amount']);
    $description = trim($_POST['description']);
    $product_id = md5(uniqid());
    $image = $_FILES['image'];
    $uploadDirectory = '../dashboard/uploads/';

    if (!is_dir($uploadDirectory)) {
        mkdir($uploadDirectory, 0755, true);
    }

    if (empty($product_name) || empty($amount) || empty($description) || empty($image['name'])) {
        $status = 'error';
        $message = 'Please fill all fields.';
    } else {
        // ✅ Check if product already exists
        $check = $conn->prepare("SELECT id FROM products WHERE product_name = ? AND description = ? AND amount = ?");
        $check->bind_param("sss", $product_name, $description, $amount);
        $check->execute();
        $check->store_result();

        if ($check->num_rows > 0) {
            $status = 'error';
            $message = '❌ This product already exists.';
        } else {
            $filename = time() . '-' . basename($image['name']);
            $targetPath = $uploadDirectory . $filename;

            if (move_uploaded_file($image['tmp_name'], $targetPath)) {
                $insert = $conn->prepare("INSERT INTO products (user_id, product_id, product_name, description, image, amount) VALUES (?, ?, ?, ?, ?, ?)");
                if ($insert) {
                    $insert->bind_param("ssssss", $admin_user_id, $product_id, $product_name, $description, $filename, $amount);
                    if ($insert->execute()) {
                        $status = 'success';
                        $message = '✅ Product created successfully.';
                    } else {
                        $status = 'error';
                        $message = 'Insert failed: ' . $insert->error;
                    }
                    $insert->close();
                } else {
                    $status = 'error';
                    $message = 'Prepare failed: ' . $conn->error;
                }
            } else {
                $status = 'error';
                $message = '❌ Failed to upload image.';
            }
        }

        $check->close();
    }
}


include 'sidebar.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>
                <div class="container">
                    <div class="text-right my-3">
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addProductModal">
                            <i class="bi bi-plus"></i> Create Product
                        </button>
                    </div>
                </div>

                <!-- Add Product Modal (Only major changes shown) -->
                <div class="modal fade" id="addProductModal">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form action="" method="POST" enctype="multipart/form-data">
                                <div class="modal-header">
                                    <h4 class="modal-title">Create Product</h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>

                                <div class="modal-body">
                                    <input type="text" name="product_name" placeholder="Product Name" class="form-control my-2" required>
                                    <textarea name="description" placeholder="Product Description" class="form-control my-2" required></textarea>
                                    <input type="text" name="amount" placeholder="Amount in USD" class="form-control my-2" required>
                                    <label for="image">Select Product Image:</label>
                                    <input type="file" name="image" id="image" accept="image/*" class="form-control" required>
                                </div>

                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-success">Submit</button>
                                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Display Products -->
                <section>
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="container-fluid">
                            <div class="card">
                                <div class="card-header">
                                    <?php if (!empty($message)) : ?>
                                        <div class="alert alert-<?php echo $status === 'success' ? 'success' : 'danger'; ?> mb-0">
                                            <?php echo htmlspecialchars($message); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (isset($_GET['status']) && $_GET['status'] === 'deleted') : ?>
                                        <div class="alert alert-success">✅ Product deleted successfully.</div>
                                    <?php endif; ?>
                                </div>

                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table">
                                        <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Image</th>
                                                    <th>Name</th>
                                                    <th>Amount</th>
                                                    <th>Bought</th>
                                                    <th>Left</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                // Fetch products from database
                                                $select_products = mysqli_query($conn, "SELECT * FROM products");
                                                if (mysqli_num_rows($select_products) > 0) {
                                                    $num = 1;
                                                    while ($row = mysqli_fetch_assoc($select_products)) {
                                                ?>
                                                        <tr>
                                                        <td><?= $num++; ?></td>
                                                        <td><img src="../dashboard/uploads/<?= htmlspecialchars($row['image']); ?>" height="80" /></td>
                                                        <td><?= htmlspecialchars($row['product_name']); ?></td>
                                                        <td>$<?= $row['amount']; ?></td>
                                                        <td><?= $row['amount_bought']; ?></td>
                                                        <td><?= $row['amount_left']; ?></td>
                                                        <td>
                                                            <a href="edit-product.php?id=<?= $row['id']; ?>" class="btn btn-primary btn-sm mb-2">Edit</a>
                                                            <a href="delete-products.php?delete=<?= $row['id']; ?>" class="btn btn-danger btn-sm">Delete</a>
                                                        </td>
                                                    </tr>
                                                <?php
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='6'>No products found.</td></tr>";
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>