<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $product_id   = $_POST['product_id'];
    $user_id      = $_POST['user_id'];
    $buyer_name   = $_POST['buyer_name']; // 👈 NEW field
    $sale_amount  = $_POST['sale_amount'];
    $quantity     = $_POST['quantity'];

    if (!empty($product_id) && !empty($user_id) && !empty($sale_amount) && !empty($quantity) && !empty($buyer_name)) {
        // Calculate total amount
        $total_amount = $sale_amount * $quantity;

        // Insert sale record
        $stmt = $conn->prepare("
            INSERT INTO product_sales (product_id, userid, buyer_name, sale_amount, quantity, total_amount, sale_date, added_by) 
            VALUES (?, ?, ?, ?, ?, ?, NOW(), 'admin')
        ");
        $stmt->bind_param("sssddd", $product_id, $user_id, $buyer_name, $sale_amount, $quantity, $total_amount);

        if ($stmt->execute()) {
            // Update account balance of the logged-in user
            $update = $conn->prepare("UPDATE user_login SET account_balance = account_balance + ? WHERE userid = ?");
            $update->bind_param("ds", $total_amount, $user_id);
            $update->execute();

            $feedback = '<div class="alert alert-success">✅ Sale added successfully! Total Amount: $' . number_format($total_amount, 2) . '</div>';
        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to add sale. Please try again.</div>';
        }
    } else {
        $feedback = '<div class="alert alert-warning">⚠️ Please fill in all fields.</div>';
    }
}

// Fetch users and their autopilot products
$query = "
    SELECT DISTINCT u.userid, u.full_name, p.product_id, p.product_name
    FROM product_promotions pp
    INNER JOIN user_login u ON pp.userid = u.userid
    INNER JOIN products p ON pp.product_id = p.product_id
    WHERE pp.autopilot = 1
    ORDER BY u.full_name ASC, p.product_name ASC
";
$result = $conn->query($query);

// Organize users and products
$user_products = [];
while ($row = $result->fetch_assoc()) {
    $user_products[$row['userid']]['name'] = $row['full_name'];
    $user_products[$row['userid']]['products'][] = [
        'product_id'   => $row['product_id'],
        'product_name' => $row['product_name']
    ];
}

// Fetch all sales for professional record display
$sales_sql = "
    SELECT s.id, u.full_name, p.product_name, s.buyer_name, s.quantity, s.sale_amount, s.total_amount, s.sale_date 
    FROM product_sales s
    INNER JOIN user_login u ON s.userid = u.userid
    INNER JOIN products p ON s.product_id = p.product_id
    ORDER BY s.sale_date DESC
";
$sales_result = $conn->query($sales_sql);
?>

<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="fw-bold">Add Sales for Autopilot Products</h4>
            </div>

            <?php echo $feedback; ?>

            <div class="card mb-4">
                <div class="card-header bg-primary text-white fw-bold">
                    Add Sale
                </div>
                <div class="card-body">
                    <form method="POST" class="row g-3">
                        <div class="col-md-6">
                            <label for="user_id" class="form-label">Select User</label>
                            <select name="user_id" id="user_id" class="form-select" required onchange="filterProducts(this.value)">
                                <option value="">-- Choose User --</option>
                                <?php foreach ($user_products as $uid => $data): ?>
                                    <option value="<?php echo $uid; ?>">
                                        <?php echo htmlspecialchars($data['name']); ?> (#<?php echo $uid; ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label for="product_id" class="form-label">Select Product</label>
                            <select name="product_id" id="product_id" class="form-select" required>
                                <option value="">-- Select User First --</option>
                            </select>
                        </div>

                        <!-- 👇 New Buyer Name Input -->
                        <div class="col-md-6">
                            <label for="buyer_name" class="form-label">Buyer’s Name</label>
                            <input type="text" name="buyer_name" id="buyer_name" class="form-control" required>
                        </div>

                        <div class="col-md-3">
                            <label for="sale_amount" class="form-label">Sale Amount ($ per unit)</label>
                            <input type="number" step="0.01" name="sale_amount" id="sale_amount" class="form-control" required>
                        </div>

                        <div class="col-md-3">
                            <label for="quantity" class="form-label">Quantity</label>
                            <input type="number" name="quantity" id="quantity" class="form-control" min="1" value="1" required>
                        </div>

                        <div class="col-md-3">
                            <label for="total_amount" class="form-label">Total Amount ($)</label>
                            <input type="number" step="0.01" name="total_amount" id="total_amount" class="form-control" readonly>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-success">💾 Save Sale</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Professional Record Section -->
            <div class="card">
                <div class="card-header bg-dark text-white fw-bold">
                    📋 Sales Records
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>User</th>
                                <th>Product</th>
                                <th>Buyer</th>
                                <th>Quantity</th>
                                <th>Sale Amount ($)</th>
                                <th>Total Amount ($)</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($sales_result && $sales_result->num_rows > 0): ?>
                                <?php while ($row = $sales_result->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $row['id']; ?></td>
                                        <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['buyer_name']); ?></td>
                                        <td><?php echo $row['quantity']; ?></td>
                                        <td><?php echo number_format($row['sale_amount'], 2); ?></td>
                                        <td><?php echo number_format($row['total_amount'], 2); ?></td>
                                        <td><?php echo $row['sale_date']; ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr><td colspan="8" class="text-center">No sales records found.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </section>
</div>

<script>
const userProducts = <?php echo json_encode($user_products); ?>;

// Filter products based on user
function filterProducts(userId) {
    const productSelect = document.getElementById('product_id');
    productSelect.innerHTML = '<option value="">-- Choose Product --</option>';

    if (userId && userProducts[userId]) {
        userProducts[userId]['products'].forEach(prod => {
            let opt = document.createElement('option');
            opt.value = prod.product_id;
            opt.textContent = prod.product_name;
            productSelect.appendChild(opt);
        });
    }
}

// Calculate total amount dynamically
const saleAmountInput = document.getElementById('sale_amount');
const quantityInput = document.getElementById('quantity');
const totalAmountInput = document.getElementById('total_amount');

function calculateTotal() {
    const amount = parseFloat(saleAmountInput.value) || 0;
    const qty = parseInt(quantityInput.value) || 0;
    totalAmountInput.value = (amount * qty).toFixed(2);
}

saleAmountInput.addEventListener('input', calculateTotal);
quantityInput.addEventListener('input', calculateTotal);
</script>

<?php include 'footer.php'; ?>
