<?php include "./include/header.php"; ?>
<?php
session_start();
?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-xl-7">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-body p-5">
                    <h2 class="text-center mb-4 text-primary">Create Your Account</h2>
                    <?php
if (isset($_GET['status']) && isset($_GET['message'])) {
    $status = $_GET['status'];
    $message = urldecode($_GET['message']);

    echo '<div class="alert alert-' . ($status === 'success' ? 'success' : 'danger') . '">' . htmlspecialchars($message) . '</div>';
}
?>
                    <form id="form1" method="POST" action="./authenticator/signin-process.php" class="row g-3 needs-validation" novalidate>
                        
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" name="full_name" class="form-control" id="fullName" placeholder="Your Full Name" required>
                                <label for="fullName">Full Name</label>
                                <div class="invalid-feedback">Please enter your full name.</div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="email" name="email" class="form-control" id="emailAddress" placeholder="name@example.com" required>
                                <label for="emailAddress">Email address</label>
                                <div class="invalid-feedback">Please enter a valid email.</div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" name="phone_number" class="form-control" id="phoneNumber" placeholder="Your Phone Number" required>
                                <label for="phoneNumber">Phone Number</label>
                                <div class="invalid-feedback">Please enter your phone number.</div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="password" name="password" class="form-control" id="inputPassword1" placeholder="Password" required>
                                <label for="inputPassword1">Password</label>
                                <div class="invalid-feedback">Please enter your password.</div>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-floating">
                                <input type="password" name="cpassword" class="form-control" id="inputPassword2" placeholder="Confirm Password" required>
                                <label for="inputPassword2">Confirm Password</label>
                                <div class="invalid-feedback">Please confirm your password.</div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" name="agree" value="1" id="termsCheck" required>
                                <label class="form-check-label" for="termsCheck">
                                    I agree to the <a href="#" target="_blank">Terms and Conditions</a>
                                </label>
                                <div class="invalid-feedback">You must agree before submitting.</div>
                            </div>
                        </div>

                        <div class="col-12 text-center">
                            <div class="g-recaptcha d-inline-block" data-sitekey="6LdEfusqAAAAACD0F8WnZ1NnH8TlJI04JYoZlsC6"></div>
                        </div>
                        
                        <div class="col-12 mt-4">
                            <button type="submit" id="submit-btn" class="btn btn-success w-100 py-2">
                                Register Now <i class="bi bi-arrow-right ms-2"></i>
                            </button>
                        </div>

                        <div class="col-12 text-center mt-3">
                            <small>
                                Already have an account? <a href="login.php" class="text-decoration-none">Login here</a><br>
                               
                            </small>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Bootstrap form validation
(() => {
    'use strict';
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault()
                event.stopPropagation()
            }
            form.classList.add('was-validated')
        }, false)
    });
})();
</script>

<?php include "./include/footer.php"; ?>
