<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
    body { background: #f9fafc; }
    .promotions-table { background: #fff; border-radius: 16px; box-shadow: 0 8px 25px rgba(0, 0, 0, 0.05); overflow: hidden; }
    .table thead { background-color: #f4f6f8; font-weight: 600; color: #333; }
    .table td, .table th { vertical-align: middle; }
    .product-img { width: 70px; height: 70px; object-fit: cover; border-radius: 10px; }
    .badge-method { background: linear-gradient(45deg, #6a11cb, #2575fc); color: white; padding: 6px 12px; border-radius: 50px; font-size: 0.75rem; }
    .btn-view { font-size: 0.875rem; font-weight: 500; color: #2575fc; background: #eef4ff; border: none; padding: 5px 10px; border-radius: 50px; transition: 0.3s ease; }
    .btn-view:hover { background: #dbe9ff; }
    .btn-activate { font-size: 0.875rem; font-weight: 500; color: white; background: #28a745; padding: 6px 12px; border-radius: 50px; text-decoration: none; }
    .btn-activate:hover { background: #218838; }
</style>

<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="section-title">🎯 All Products & Autopilot Status</h2>
        <p class="small-muted">View all your products. Activate autopilot to start automated promotion.</p>
    </div>

    <div class="promotions-table p-4">
        <div class="table-responsive">
            <table class="table align-middle table-borderless">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Autopilot</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // ✅ Use subquery to get only latest promotion per product
                    $stmt = $conn->prepare("
                        SELECT p.*,
                               COALESCE(pr.autopilot, 0) AS autopilot,
                               pr.promotion_fee,
                               pr.payment_method,
                               pr.payment_proof,
                               pr.created_at
                        FROM products p
                        LEFT JOIN (
                            SELECT pp.*
                            FROM product_promotions pp
                            WHERE pp.userid = ?
                            AND pp.created_at = (
                                SELECT MAX(pp2.created_at)
                                FROM product_promotions pp2
                                WHERE pp2.product_id = pp.product_id
                                  AND pp2.userid = pp.userid
                            )
                        ) pr ON p.product_id = pr.product_id
                        ORDER BY p.created_at DESC
                    ");
                    $stmt->bind_param("s", $userid);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $count = 1;

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $desc_words = explode(' ', strip_tags($row['description']));
                            $short_desc = implode(' ', array_slice($desc_words, 0, 10));
                    ?>
                        <tr>
                            <td><?= $count++ ?></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="./uploads/<?= htmlspecialchars($row['image']) ?>" class="product-img me-3" alt="">
                                    <div>
                                        <div class="fw-bold"><?= htmlspecialchars($row['product_name']) ?></div>
                                        <small class="text-muted">#<?= substr($row['product_id'], 0, 8) ?></small>
                                    </div>
                                </div>
                            </td>
                            <td><?= htmlspecialchars($short_desc) ?><?= count($desc_words) > 10 ? '...' : '' ?></td>

                            <!-- Status -->
                            <td>
                                <?php if (!empty($row['autopilot']) && $row['autopilot'] == 1): ?>
                                    <span class="badge bg-success">Activated</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Not Activated</span>
                                <?php endif; ?>
                            </td>

                            <!-- Autopilot Action -->
                            <td>
                                <?php if (!empty($row['autopilot']) && $row['autopilot'] == 1): ?>
                                    ✅ Running
                                <?php else: ?>
                                    <a href="activate_autopilot.php?product_id=<?= $row['product_id'] ?>" class="btn-activate">
                                        Activate Autopilot
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>

                        <!-- Show "View Sales" button only if autopilot is active -->
                        <?php if (!empty($row['autopilot']) && $row['autopilot'] == 1): ?>
                        <tr>
                            <td colspan="5" class="text-left">
                                <a href="view_sales.php?product_id=<?= urlencode($row['product_id']) ?>" 
                                   class="btn btn-outline-primary btn-sm rounded-pill">
                                    📊 View Sales Report
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    <?php
                        }
                    } else {
                        echo "<tr><td colspan='5' class='text-center text-muted'>😕 No products found.</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="text-center mt-4">
        <a href="dashboard.php" class="text-decoration-none small text-primary">← Back to Dashboard</a>
    </div>
</div>

<?php include "footer.php"; ?>



<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
    body { background: #f9fafc; }
    .promotions-table { background: #fff; border-radius: 16px; box-shadow: 0 8px 25px rgba(0, 0, 0, 0.05); overflow: hidden; }
    .table thead { background-color: #f4f6f8; font-weight: 600; color: #333; }
    .table td, .table th { vertical-align: middle; }
    .product-img { width: 70px; height: 70px; object-fit: cover; border-radius: 10px; }
    .badge-method { background: linear-gradient(45deg, #6a11cb, #2575fc); color: white; padding: 6px 12px; border-radius: 50px; font-size: 0.75rem; }
    .btn-view { font-size: 0.875rem; font-weight: 500; color: #2575fc; background: #eef4ff; border: none; padding: 5px 10px; border-radius: 50px; transition: 0.3s ease; }
    .btn-view:hover { background: #dbe9ff; }
    .btn-activate { font-size: 0.875rem; font-weight: 500; color: white; background: #28a745; padding: 6px 12px; border-radius: 50px; text-decoration: none; }
    .btn-activate:hover { background: #218838; }
</style>

<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="section-title">🎯 All Products & Autopilot Status</h2>
        <p class="small-muted text-white">View all your products. Activate autopilot to start automated promotion.</p>
    </div>

    <div class="promotions-table p-4">
        <div class="table-responsive">
            <table class="table align-middle table-borderless">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Autopilot</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Fetch products with latest approved autopilot status
                    $stmt = $conn->prepare("
                        SELECT p.*,
                               COALESCE(
                                   (SELECT 1 FROM product_promotions pp 
                                    WHERE pp.product_id = p.product_id 
                                      AND pp.userid = ? 
                                      AND pp.status = 'approved' 
                                    ORDER BY pp.created_at DESC LIMIT 1), 0
                               ) AS is_approved
                        FROM products p
                        ORDER BY p.created_at DESC
                    ");
                    $stmt->bind_param("s", $userid);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $count = 1;

                    
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $desc_words = explode(' ', strip_tags($row['description']));
        $short_desc = implode(' ', array_slice($desc_words, 0, 10));
?>
    <tr>
        <td><?= $count++ ?></td>
        <td>
            <div class="d-flex align-items-center">
                <img src="./uploads/<?= htmlspecialchars($row['image']) ?>" class="product-img me-3" alt="">
                <div>
                    <div class="fw-bold"><?= htmlspecialchars($row['product_name']) ?></div>
                    <small class="text-muted">#<?= substr($row['product_id'], 0, 8) ?></small>
                </div>
            </div>
        </td>
        <td><?= htmlspecialchars($short_desc) ?><?= count($desc_words) > 10 ? '...' : '' ?></td>

        <!-- Status -->
        <td>
            <?php if ($row['is_approved']): ?>
                <span class="badge bg-success">Approved</span>
            <?php else: ?>
                <span class="badge bg-secondary">Pending</span>
            <?php endif; ?>
        </td>

        <!-- Autopilot Action -->
        <td>
            <?php if ($row['is_approved']): ?>
                ✅ Running
            <?php else: ?>
                <a href="activate_autopilot.php?product_id=<?= $row['product_id'] ?>" class="btn-activate">
                    Activate Autopilot
                </a>
            <?php endif; ?>
        </td>
    </tr>

    <!-- View Sales Report Button (only for approved products) -->
    <?php if ($row['is_approved']): ?>
    <tr>
        <td colspan="5" class="text-start ps-5">
            <a href="view_sales.php?product_id=<?= urlencode($row['product_id']) ?>" 
               class="btn btn-outline-primary btn-sm rounded-pill">
                📊 View Sales Report
            </a>
        </td>
    </tr>
    <?php endif; ?>
<?php
    }
} else {
    echo "<tr><td colspan='5' class='text-center text-muted'>😕 No products found.</td></tr>";
}
?>

                </tbody>
            </table>
        </div>
    </div>

    <div class="text-center mt-4">
        <a href="dashboard.php" class="text-decoration-none small text-primary">← Back to Dashboard</a>
    </div>
</div>

<?php include "footer.php"; ?>
