<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];

// ✅ Fetch messages where the logged-in user is the receiver
$messages = [];
$sql = "SELECT pm.*, p.product_name
        FROM product_messages pm
        LEFT JOIN products p ON pm.product_id = p.product_id
        WHERE pm.receiver_id = ? AND pm.sender_role = 'admin'
        ORDER BY pm.sent_at DESC";

$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("s", $userid);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $messages[] = $row;
    }
    $stmt->close();
} else {
    die("SQL prepare failed: " . $conn->error);
}
?>  

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
    html, body {
        height: 100%;
        background-color: #f8f9fa;
        margin: 0;
    }
    .page-wrapper {
        display: flex;
        flex-direction: column;
        min-height: 100vh;
    }
    .content {
        flex: 1;
    }
    .message-card {
        transition: all 0.2s ease-in-out;
        border-radius: 14px;
    }
    .message-card:hover {
        background-color: #f1f5f9;
        transform: scale(1.01);
    }
    .new-badge {
        background-color: #e11d48;
        font-size: 12px;
        padding: 4px 8px;
        border-radius: 20px;
        font-weight: bold;
        color: white;
    }
    .message-snippet {
        color: #6c757d;
    }
    .timestamp {
        font-size: 12px;
        color: #adb5bd;
    }
</style>

<div class="page-wrapper">
    <div class="content container py-5">
        <h3 class="fw-bold mb-4 text-center text-white">📨 Messages From Buyers</h3>

        <?php if (empty($messages)) : ?>
            <div class="text-center text-muted p-5 bg-white shadow-sm rounded">
                <i class="fas fa-inbox fa-2x mb-2"></i>
                <p class="mb-0">You have no messages at this time.</p>
            </div>
        <?php else : ?>
            <div class="row g-3">
                <?php foreach ($messages as $msg) : ?>
                    <div class="col-md-6 col-lg-4">
                        <a href="chat.php?product_id=<?= urlencode($msg['product_id']); ?>" class="text-decoration-none">
                            <div class="bg-white p-4 shadow-sm message-card h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h5 class="text-dark fw-semibold mb-1">
                                        <i class="fas fa-box-open me-2 text-primary"></i><?= htmlspecialchars($msg['product_name'] ?? 'Unnamed Product') ?>
                                    </h5>
                                    <p class="message-snippet mb-2">
                                        <?= htmlspecialchars(function_exists('mb_strimwidth') ? mb_strimwidth($msg['message'], 0, 100, '...') : substr($msg['message'], 0, 100) . '...') ?>
                                    </p>
                                </div>

                                <div class="d-flex justify-content-between align-items-center mt-2">
                                    <small class="timestamp">
                                        <?= date("F j, Y g:i a", strtotime($msg['sent_at'])) ?>
                                    </small>
                                    <?php if ($msg['seen'] == 0) : ?>
                                        <span class="new-badge">New</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php include "footer.php"; ?>
</div>
