<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";

// Fetch all products
$all_products = mysqli_query($conn, "SELECT product_id, product_name FROM products ORDER BY created_at DESC");

// Fetch all users
$all_users = mysqli_query($conn, "SELECT userid, full_name FROM user_login ORDER BY created_at DESC");

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $product_id = $_POST['product_id'];
    $user_id    = $_POST['user_id'];
    $sale_amount = $_POST['sale_amount'];

    if (!empty($product_id) && !empty($user_id) && !empty($sale_amount)) {
        $stmt = $conn->prepare("INSERT INTO product_sales (product_id, userid, sale_amount, sale_date, added_by) VALUES (?, ?, ?, NOW(), 'admin')");
        $stmt->bind_param("ssd", $product_id, $user_id, $sale_amount);

        if ($stmt->execute()) {
            $feedback = '<div class="alert alert-success">✅ Sale added successfully.</div>';
        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to add sale. Please try again.</div>';
        }
    } else {
        $feedback = '<div class="alert alert-warning">⚠️ Please fill in all fields.</div>';
    }
}
?>

<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <div class="card">
                <div class="card-header bg-primary text-white fw-bold">
                    Add Sale for a Promoted Product
                </div>
                <div class="card-body">

                    <?php echo $feedback; ?>

                    <form method="POST" class="row g-3">
                        <div class="col-md-6">
                            <label for="product_id" class="form-label">Select Product</label>
                            <select name="product_id" id="product_id" class="form-select" required>
                                <option value="">-- Choose Product --</option>
                                <?php while ($prod = mysqli_fetch_assoc($all_products)) : ?>
                                    <option value="<?php echo $prod['product_id']; ?>">
                                        <?php echo htmlspecialchars($prod['product_name']); ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label for="user_id" class="form-label">Select User</label>
                            <select name="user_id" id="user_id" class="form-select" required>
                                <option value="">-- Choose User --</option>
                                <?php while ($user = mysqli_fetch_assoc($all_users)) : ?>
                                    <option value="<?php echo $user['userid']; ?>">
                                        <?php echo htmlspecialchars($user['full_name']); ?> (#<?php echo $user['userid']; ?>)
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label for="sale_amount" class="form-label">Sale Amount ($)</label>
                            <input type="number" step="0.01" name="sale_amount" id="sale_amount" class="form-control" required>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-success">💾 Save Sale</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
</div>

<?php include 'footer.php'; ?>
