<?php
// Include database connection file
include_once("../_db.php");

// Initialize variables
$status = $message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bedrooms = $_POST['bedrooms'];
    $location = $_POST['location'];
    $images = $_FILES['image'];

    // Check if all fields are filled
    if (empty($bedrooms) || empty($location) || empty($images['name'][0])) {
        $status = 'error';
        $message = 'Please fill all fields';
    } else {
        // File upload handling
        $uploadDirectory = '../rental/';
        
        foreach ($images['name'] as $key => $image_name) {
            $fileName = basename($image_name);
            $targetPath = $uploadDirectory . $fileName;
            
            // Check if file already exists
            if (file_exists($targetPath)) {
                $status = 'error';
                $message = 'File ' . $fileName . ' already exists';
                break;
            } else {
                // Upload file
                if (!move_uploaded_file($images['tmp_name'][$key], $targetPath)) {
                    $status = 'error';
                    $message = 'Failed to upload file ' . $fileName;
                    break;
                }
            }
        }
        
        if (!isset($status)) {
            // Insert into database
            $insertQuery = "INSERT INTO rentals (bedrooms, location, image) VALUES (?, ?, ?)";
            $insertStmt = $conn->prepare($insertQuery);
            
            // Check if prepare() was successful
            if ($insertStmt) {
                foreach ($images['name'] as $key => $image_name) {
                    $fileName = basename($image_name);
                    $insertStmt->bind_param("sss", $bedrooms, $location, $fileName);
                    $insertStmt->execute();
                }

                $status = 'success';
                $message = 'Rental added successfully';
            } else {
                $status = 'error';
                $message = 'Failed to prepare SQL statement';
            }
        }
    }

    // Display status message
    if ($status) {
        echo '<div style="color: ' . ($status === 'success' ? 'green' : 'red') . ';">' . $message . '</div>';
    }
}

?>

<form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" enctype="multipart/form-data">
    <label for="bedrooms">Bedrooms:</label>
    <input type="number" name="bedrooms" id="bedrooms" required><br><br>
    
    <label for="location">Location:</label>
    <input type="text" name="location" id="location" required><br><br>
    
    <label for="image[]">Select Image:</label>
    <input type="file" name="image[]" id="image" accept="image/png, image/jpeg" multiple required><br><br>
    
    <input type="submit" value="Submit">
</form>

