<?php
include 'head.php';
include 'header.php';
include_once("../_db.php"); // Database connection

$status = $message = '';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_name = $_POST['product_name'];
    $amount = $_POST['amount'];
    $description = $_POST['description'];
    $product_id = md5(uniqid());

    // Check if all required fields are filled
    if (empty($product_name) || empty($amount) || empty($description) || empty($_FILES['image']['name'][0])) {
        $status = 'error';
        $message = 'Please fill all fields';
    } else {
        // File upload handling
        $uploadDirectory = '../uploads/products/'; 
        // Create the directory if it doesn't exist
        if (!is_dir($uploadDirectory)) {
            mkdir($uploadDirectory, 0755, true);
        }

        // Loop through each uploaded image
        foreach ($_FILES['image']['tmp_name'] as $key => $tmp_name) {
            $fileName = basename($_FILES['image']['name'][$key]);
            $targetPath = $uploadDirectory . time() . '-' . $fileName; // Add timestamp for uniqueness

            // Check if file already exists
            if (file_exists($targetPath)) {
                $status = 'error';
                $message = 'File already exists: ' . htmlspecialchars($fileName);
                break;
            } else {
                // Upload file
                if (!move_uploaded_file($_FILES['image']['tmp_name'][$key], $targetPath)) {
                    $status = 'error';
                    $message = 'Failed to upload file: ' . htmlspecialchars($fileName);
                    break;
                } else {
                    // Insert product into the database
                    $insertQuery = "INSERT INTO products (product_id, product_name, amount, description, image) VALUES (?, ?, ?, ?, ?)";
                    $insertStmt = $conn->prepare($insertQuery);

                    if ($insertStmt) {
                        $insertStmt->bind_param("sssss", $product_id, $product_name, $amount, $description, basename($targetPath)); // Save the unique file name
                        if ($insertStmt->execute()) {
                            $status = 'success';
                            $message = 'Product added successfully';
                        } else {
                            $status = 'error';
                            $message = 'Failed to insert product: ' . $insertStmt->error;
                            break;
                        }
                    } else {
                        $status = 'error';
                        $message = 'Failed to prepare SQL statement: ' . $conn->error;
                        break;
                    }
                }
            }
        }
    }

    // Display status message
    if ($status) {
        echo '<div style="color: ' . ($status === 'success' ? 'green' : 'red') . ';">' . htmlspecialchars($message) . '</div>';
    }
}
include 'sidebar.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>
                <div class="container">
                    <div class="text-right my-3">
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addProductModal">
                            <i class="bi bi-plus"></i> Add Product
                        </button>
                    </div>
                </div>

                <!-- Add Product Modal -->
                <div class="modal fade" id="addProductModal">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <!-- Modal Header -->
                            <div class="modal-header">
                                <h4 class="modal-title">Add Product</h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <!-- Modal Body -->
                            <div class="modal-body">
                                <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="POST" enctype="multipart/form-data">
                                    <div class="form-group">
                                        <input type="text" name="product_name" placeholder="Enter product name" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="amount" placeholder="Enter product amount" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <textarea name="description" cols="30" rows="5" class="form-control my-2" placeholder="Enter product description" required></textarea>
                                    </div>
                                    <label for="image">Select Images:</label>
                                    <input type="file" name="image[]" id="image" accept="image/png, image/jpeg, image/webp" multiple required><br><br>

                                    <!-- Modal Footer -->
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success">Submit</button>
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Display Products -->
                <section>
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="container-fluid">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Product Image</th>
                                                    <th>Product Name</th>
                                                    <th>Description</th>
                                                    <th>Amount</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                // Fetch products from database
                                                $select_products = mysqli_query($conn, "SELECT * FROM products");
                                                if (mysqli_num_rows($select_products) > 0) {
                                                    $num = 1;
                                                    while ($row = mysqli_fetch_assoc($select_products)) {
                                                ?>
                                                <tr>
                                                    <td><?php echo $num++; ?></td>
                                                    <td><img src="../uploads/products/<?php echo htmlspecialchars($row['image']); ?>" height="100" alt=""></td>
                                                    <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['description']); ?></td>
                                                    <td>$<?php echo $row['amount']; ?></td>
                                                    <td>
                                                        <a href="product-details.php?product_id=<?php echo htmlspecialchars($row['product_id']); ?>" class="btn btn-info btn-sm"><i class="bi bi-eye-fill" style="font-size: 20px;"></i></a>
                                                    </td>
                                                </tr>
                                                <?php 
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='6'>No products found.</td></tr>";
                                                }
                                                ?> 
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>
