<?php
@session_start();
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if the 'add_blog' button is clicked
    if (isset($_POST['add_blog'])) {
        // Generate a unique blog_id
        $blogId = md5(uniqid());

        // Collect other form data
        $title = $_POST['title'];
        $subTitle = $_POST['sub_title'];
        $categories = $_POST['categories'];
        $tags = $_POST['tags'];
        $description = $_POST['description'];

        // File upload handling
        $uploadDirectory = "../blog/"; // Set your desired upload directory
        $uploadedFileName = basename($_FILES["blog_img"]["name"]);
        $targetFilePath = $uploadDirectory . $uploadedFileName;
        $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));

        // Check if the file is an image
        $isImage = getimagesize($_FILES["blog_img"]["tmp_name"]);
        if ($isImage === false) {
            header('Location: manage-blog.php?status=success&message=Please upload a valid image file');
            exit();
        }

        // Check file size (you can adjust the size as needed)
        $maxFileSize = 5 * 1024 * 1024; // 5 MB
        if ($_FILES["blog_img"]["size"] > $maxFileSize) {
            header('Location: manage-blog.php?status=success&message=File size is too large.');
            exit();
        }

        // Allow only certain file formats (you can adjust the formats as needed)
        $allowedFormats = ["jpg", "jpeg", "png"];
        if (!in_array($fileType, $allowedFormats)) {
            header('Location: manage-blog.php?status=success&message=Only JPG, JPEG, and PNG files are allowed.');
            exit();
        }

        // Move the uploaded file to the desired directory
        if (move_uploaded_file($_FILES["blog_img"]["tmp_name"], $targetFilePath)) {
            // Extract only the filename without the folder path
            $filename = basename($uploadedFileName);

            // File upload successful, you can now proceed to store the data in the database
            // (Make sure to use prepared statements for security)

            // Example database connection and query (replace with your actual code)
            require_once("../_db.php");

            $stmt = $conn->prepare("INSERT INTO blog (blog_id, title, sub_title, categories, tags, description, blog_img) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssss", $blogId, $title, $subTitle, $categories, $tags, $description, $filename);
            $stmt->execute();

            $stmt->close();
            $conn->close();

            header('Location: manage-blog.php?status=success&message=Blog added successfully!');
            exit();
        } else {
            header('Location: manage-blog.php?status=error&message=There was an issue uploading your file.');
            exit();
        }
    }
}
?>
