<?php
require_once('../_db.php');

$userId = $_GET['user'] ?? null;
$productId = $_GET['product'] ?? null;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Chat</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background-color: #f1f3f6; margin: 0; font-family: 'Segoe UI', sans-serif; }
        .chat-wrapper { display: flex; justify-content: center; align-items: flex-start; min-height: 100vh; padding: 10px; }
        .chat-container { background: white; border-radius: 10px; width: 100%; max-width: 900px; box-shadow: 0 8px 24px rgba(0,0,0,0.08); padding: 20px; display: flex; flex-direction: column; height: 90vh; }
        .chat-box { flex: 1; overflow-y: auto; border: 1px solid #eee; padding: 15px; border-radius: 8px; background: #fdfdfd; }
        .message { margin-bottom: 12px; padding: 10px 16px; border-radius: 18px; word-wrap: break-word; box-shadow: 0 2px 5px rgba(0,0,0,0.05); max-width: 85%; }
        .admin { background-color: #d1ecf1; margin-left: auto; text-align: right; }
        .user { background-color: #f1f1f1; margin-right: auto; }
        .timestamp { font-size: 0.75rem; color: #6c757d; margin-top: 5px; }
        .chat-form textarea { border-radius: 12px; resize: none; }
        .ios-send-button { background-color: #007aff; color: white; border: none; border-radius: 18px; padding: 10px 25px; font-weight: 500; width: 100%; }
        @media (max-width: 576px) {
            .chat-container { height: 100vh; border-radius: 0; padding: 15px; width: 100%; max-width: 100%; }
            .chat-box { padding: 10px; }
            .ios-send-button { font-size: 1.1rem; }
        }
        .go-back { margin-bottom: 1rem; }
        .go-back a { text-decoration: none; font-weight: 600; color: #007bff; }
        .go-back a:hover { text-decoration: underline; }
    </style>
</head>
<body>
<div class="chat-wrapper">
    <div class="chat-container">
        <div class="go-back">
            <a href="dashboard.php"><i class="bi bi-arrow-left-circle-fill"></i> Back to Dashboard</a>
        </div>
        <?php if ($userId && $productId): ?>
            <div class="mb-3">
                <?php
                $stmtName = $conn->prepare("SELECT full_name FROM user_login WHERE userid = ?");
                $stmtName->bind_param("s", $userId);
                $stmtName->execute();
                $resultName = $stmtName->get_result();
                $userFullName = $resultName->fetch_assoc()['full_name'] ?? $userId;
                $stmtName->close();

                $stmtProduct = $conn->prepare("SELECT product_name FROM create_products WHERE id = ?");
                $stmtProduct->bind_param("i", $productId);
                $stmtProduct->execute();
                $resultProduct = $stmtProduct->get_result();
                $productName = $resultProduct->fetch_assoc()['product_name'] ?? 'Unknown Product';
                $stmtProduct->close();
                ?>
                <h5>Chat with <?php echo htmlspecialchars($userFullName); ?> about "<?php echo htmlspecialchars($productName); ?>"</h5>
                <a href="admin-chat.php">← Back to Messages List</a>
            </div>
            <div class="chat-box mb-3" id="chatBox">
                <!-- Messages will be loaded here via JavaScript -->
            </div>
            <form action="send-admin-message.php" method="POST" class="chat-form position-relative">
                <input type="hidden" name="receiver_id" value="<?php echo htmlspecialchars($userId); ?>">
                <input type="hidden" name="product_id" value="<?php echo htmlspecialchars($productId); ?>">
                <textarea name="message" rows="3" class="form-control mb-2 pe-5" placeholder="Type your message..." required></textarea>
                <button type="submit" class="btn position-absolute bottom-0 end-0 mb-3 me-3 text-primary border-0 bg-transparent" style="font-size: 1.5rem;" title="Send">
                    <i class="bi bi-send-fill"></i>
                </button>
            </form>
<?php else: ?>
            <h4 class="mb-4">User Conversations</h4>
            <div class="list-group mb-4">
                <?php
                $query = "
                    SELECT 
                        m1.sender_id, 
                        m1.receiver_id,
                        m1.product_id,
                        ul.full_name, 
                        cp.product_name,
                        m1.message AS last_message,
                        m1.created_at AS latest_message_time
                    FROM messages m1
                    INNER JOIN (
                        SELECT 
                            CASE 
                                WHEN sender_id = 'admin' THEN receiver_id 
                                ELSE sender_id 
                            END AS user_id,
                            product_id,
                            MAX(created_at) AS max_time
                        FROM messages
                        WHERE (sender_id = 'admin' OR receiver_id = 'admin') AND product_id != 0
                        GROUP BY user_id, product_id
                    ) m2 ON 
                        ((m1.sender_id = 'admin' AND m1.receiver_id = m2.user_id) OR 
                        (m1.receiver_id = 'admin' AND m1.sender_id = m2.user_id)) 
                        AND m1.product_id = m2.product_id 
                        AND m1.created_at = m2.max_time
                    LEFT JOIN user_login ul ON m1.sender_id = ul.userid OR m1.receiver_id = ul.userid
                    LEFT JOIN create_products cp ON m1.product_id = cp.id
                    WHERE m1.product_id != 0
                    ORDER BY m1.created_at DESC
                ";
                $result = $conn->query($query);
                while ($row = $result->fetch_assoc()):
                    $userId = ($row['sender_id'] === 'admin') ? $row['receiver_id'] : $row['sender_id'];
                    $fullName = htmlspecialchars($row['full_name'] ?? $userId);
                    $productName = htmlspecialchars($row['product_name'] ?? 'Unknown Product');
                    $productId = htmlspecialchars($row['product_id']);
                    $lastMessage = htmlspecialchars(substr($row['last_message'], 0, 50)) . '...';
                    $timestamp = date("M j • g:i A", strtotime($row['latest_message_time']));
                ?>
                    <a href="admin-chat.php?user=<?php echo $userId; ?>&product=<?php echo $productId; ?>" 
                       class="list-group-item list-group-item-action d-flex align-items-start gap-3 shadow-sm border-0 rounded-3 mb-2 p-3">
                        <div class="flex-shrink-0">
                            <div class="bg-primary text-white rounded-circle d-flex justify-content-center align-items-center" 
                                 style="width: 48px; height: 48px; font-weight: bold;">
                                <?php echo strtoupper(substr($fullName, 0, 1)); ?>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0 text-dark"><?php echo $fullName; ?></h6>
                                <small class="text-muted"><?php echo $timestamp; ?></small>
                            </div>
                            <div class="text-muted small mb-1">Product: <?php echo $productName; ?> (#<?php echo $productId; ?>)</div>
                            <div class="text-secondary small"><?php echo $lastMessage; ?></div>
                        </div>
                    </a>
                <?php endwhile; ?>
            </div>
            <h5 class="mb-3">Start New Conversation</h5>
            <form method="get" action="admin-chat.php" class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Select User</label>
                    <select name="user" class="form-select" required>
                        <option value="">-- Choose User --</option>
                        <?php
                        $users = $conn->query("SELECT userid, full_name FROM user_login ORDER BY full_name ASC");
                        while ($u = $users->fetch_assoc()):
                            echo '<option value="'.htmlspecialchars($u['userid']).'">'.htmlspecialchars($u['full_name']).'</option>';
                        endwhile;
                        ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Select Product</label>
                    <select name="product" class="form-select" required>
                        <option value="">-- Choose Product --</option>
                        <?php
                        $products = $conn->query("SELECT id, product_name FROM create_products ORDER BY product_name ASC");
                        while ($p = $products->fetch_assoc()):
                            echo '<option value="'.htmlspecialchars($p['id']).'">'.htmlspecialchars($p['product_name']).'</option>';
                        endwhile;
                        ?>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">Start Chat</button>
                </div>
            </form>
        <?php endif; ?>
    </div>
</div>

<?php if ($userId && $productId): ?>
<script>
    function loadMessages() {
        const userId = '<?php echo $userId; ?>';
        const productId = '<?php echo $productId; ?>';

        fetch(`fetch-messages.php?user=${userId}&product=${productId}`)
            .then(response => response.json())
            .then(data => {
                const chatBox = document.getElementById('chatBox');
                chatBox.innerHTML = '';
                data.messages.forEach(msg => {
                    const messageDiv = document.createElement('div');
                    messageDiv.classList.add('message', msg.isAdmin ? 'admin' : 'user');
                    messageDiv.innerHTML = `
                        <div>${msg.message}</div>
                        <div class="timestamp">${msg.created_at}</div>
                    `;
                    chatBox.appendChild(messageDiv);
                });
                chatBox.scrollTop = chatBox.scrollHeight;
            })
            .catch(console.error);
    }

    loadMessages(); // Load initially
    setInterval(loadMessages, 2000); // Reload every 2 seconds
</script>
<?php endif; ?>

</body>
</html>
