<?php
session_start();
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";
include "./include/_db.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];

// Fetch user's profit balance
$stmt = $conn->prepare("SELECT profit_balance FROM user_login WHERE userid = ?");
$stmt->bind_param("s", $userid);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$current_profit = $data['profit_balance'] ?? 0.00;

// Simulate a short profit trend using only the current balance
$profitHistory = [];
$step = $current_profit / 6;
for ($i = 1; $i <= 6; $i++) {
    $profitHistory[] = round($step * $i + rand(-5, 5), 2);
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
    body {
        background: #f4f6fa;
        font-family: 'Segoe UI', sans-serif;
    }

    .chart-card {
        background: #fff;
        border-radius: 18px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.06);
        padding: 30px;
    }

    .profit-value {
        font-size: 2.3rem;
        font-weight: 600;
        color: #333;
    }

    .profit-label {
        color: #666;
        font-size: 14px;
    }

    .chart-container {
        width: 100%;
        height: auto;
        position: relative;
    }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 chart-card">
            <div class="text-center mb-4">
                <h4 class="fw-semibold">Your Profit Trend</h4>
                <p class="text-muted mb-0">Based on your current profit balance</p>
            </div>

            <div class="chart-container">
                <canvas id="profitChart"></canvas>
            </div>

            <div class="text-center mt-4">
                <div class="profit-value">$<?php echo number_format($current_profit, 2); ?></div>
                <div class="profit-label">Total Profit Balance</div>
            </div>
        </div>
    </div>
</div>

<script>
    const ctx = document.getElementById('profitChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ["", "", "", "", "", ""],
            datasets: [{
                data: <?php echo json_encode($profitHistory); ?>,
                fill: true,
                backgroundColor: 'rgba(102, 126, 234, 0.15)',
                borderColor: '#667eea',
                borderWidth: 3,
                pointRadius: 3,
                pointBackgroundColor: '#764ba2',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: { display: false },
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: (value) => '$' + value,
                        color: '#999',
                        font: { size: 12 }
                    }
                }
            },
            plugins: {
                legend: { display: false },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return "$" + context.parsed.y;
                        }
                    }
                }
            }
        }
    });
</script>

<?php include "footer.php"; ?>
