<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $user_id = $_SESSION['userid'];
    $product_id = uniqid("prod_"); // ✅ Generate unique product ID
    $product_name = mysqli_real_escape_string($conn, $_POST['product_name']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $amount = floatval($_POST['amount']);
    $image = $_FILES['image'];

    // Fetch user balance
    $balanceQuery = mysqli_query($conn, "SELECT account_balance FROM user_login WHERE userid = '$user_id'");
    if ($balanceQuery && mysqli_num_rows($balanceQuery) > 0) {
        $userData = mysqli_fetch_assoc($balanceQuery);
        $current_balance = floatval($userData['account_balance']);

        if ($current_balance >= $amount) {
            // Proceed with image upload
            if ($image['error'] === 0) {
                $imgName = time() . "_" . basename($image['name']);
                $uploadPath = "uploads/" . $imgName;

                if (move_uploaded_file($image['tmp_name'], $uploadPath)) {
                    // ✅ Insert product with product_id
                    $stmt = $conn->prepare("INSERT INTO products (product_id, user_id, product_name, description, amount, image, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
                    if (!$stmt) {
                        die("Prepare failed: " . $conn->error);
                    }
                    $stmt->bind_param("ssssds", $product_id, $user_id, $product_name, $description, $amount, $imgName);

                    if ($stmt->execute()) {
                        // Deduct balance
                        mysqli_query($conn, "UPDATE user_login SET account_balance = account_balance - $amount WHERE userid = '$user_id'");
                        $success = "✅ Project uploaded successfully. Product ID: $product_id";
                    } else {
                        $error = "❌ Insert failed: " . $stmt->error;
                    }

                    $stmt->close();
                } else {
                    $error = "❌ Failed to upload image.";
                }
            } else {
                $error = "❌ Please select a valid image.";
            }
        } else {
            $error = "❌ Insufficient balance. You need $$amount but have $$current_balance.";
        }
    } else {
        $error = "❌ Failed to retrieve user balance.";
    }
}
?>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    .btn-gradient {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        transition: 0.3s ease-in-out;
    }

    .btn-gradient:hover {
        filter: brightness(1.1);
        transform: scale(1.02);
    }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <div class="text-center mb-5">
                <h2 class="fw-bold text-white">🚀 Launch Your Own Project</h2>
                <p class="text-white">Showcase your creativity and sell your digital services with ease.</p>
            </div>

            <?php if (isset($error)) : ?>
                <div class="alert alert-danger text-center shadow-sm"><?php echo $error; ?></div>
            <?php elseif (isset($success)) : ?>
                <div class="alert alert-success text-center shadow-sm"><?php echo $success; ?></div>
            <?php endif; ?>

            <div class="card border-0 shadow-lg rounded-4 p-4">
                <form method="POST" enctype="multipart/form-data" class="row g-4">
                    <div class="col-12">
                        <label class="form-label fw-semibold">Project Title</label>
                        <input type="text" name="product_name" class="form-control rounded-pill px-4 py-2" placeholder="E.g. Social Media Campaign" required>
                    </div>

                    <div class="col-12">
                        <label class="form-label fw-semibold">Project Description</label>
                        <textarea name="description" class="form-control px-4 py-3 rounded-4" rows="5" placeholder="Describe your project in detail..." required></textarea>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Project Price (USD)</label>
                        <input type="number" name="amount" class="form-control rounded-pill px-4 py-2" step="0.01" placeholder="E.g. 150.00" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Upload Image</label>
                        <input type="file" name="image" class="form-control rounded-pill px-4 py-2" accept="image/*" required>
                    </div>

                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-lg btn-gradient rounded-pill px-5 shadow">
                            <i class="fas fa-cloud-upload-alt me-2"></i> Publish Project
                        </button>
                    </div>
                </form>
            </div>

            <div class="text-center mt-4">
                <a href="projects.php" class="text-muted text-decoration-none small">
                    <i class="fas fa-arrow-left me-1"></i> Back to Projects
                </a>
            </div>
        </div>
    </div>
</div>

<?php include "footer.php"; ?>
