<?php
session_start();
include "../_db.php";

// Check login
if (!isset($_SESSION['userid'])) {
    echo "<div class='container py-5'><div class='alert alert-danger'>You must be logged in to buy a project.</div></div>";
    exit;
}

$userid = $_SESSION['userid'];

// Validate POST
if (!isset($_POST['product_id'], $_POST['amount'])) {
    echo "<div class='container py-5'><div class='alert alert-danger'>Invalid purchase request.</div></div>";
    exit;
}

$product_id = mysqli_real_escape_string($conn, $_POST['product_id']);
$amount = floatval($_POST['amount']);

// Fetch user
$user_q = mysqli_query($conn, "SELECT account_balance FROM user_login WHERE userid = '$userid'");
$user = mysqli_fetch_assoc($user_q);

if (!$user) {
    echo "<div class='container py-5'><div class='alert alert-danger'>User not found.</div></div>";
    exit;
}

// Check balance
$current_balance = floatval($user['account_balance']);
if ($current_balance < $amount) {
    header("Location: buy-project.php?product_id=$product_id&error=Insufficient+balance");
    exit;
}

// Deduct balance
// Deduct balance
$new_balance = $current_balance - $amount;
$update_q = mysqli_query($conn, "UPDATE user_login SET account_balance = '$new_balance' WHERE userid = '$userid'");

// Optional: log purchase
mysqli_query($conn, "INSERT INTO project_purchases (userid, product_id, amount, purchased_at) VALUES ('$userid', '$product_id', '$amount', NOW())");

// Success message
// Redirect with success message
header("Location: buy-project.php?product_id=$product_id&success=Project+purchase+successful");
exit;
?>
