<?php
session_start();
include "./include/head.php";
include "./include/navbar.php";
include "sidebar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$partner_id = $_GET['sender_id'] ?? '';
$partner_role = $_GET['role'] ?? '';

// ✅ Fetch the real admin user ID from the database
if ($partner_id === 'admin') {
    $admin_query = $conn->query("SELECT userid FROM user_login WHERE role = 'admin' LIMIT 1");
    if ($admin_query && $admin_query->num_rows > 0) {
        $partner_db_id = $admin_query->fetch_assoc()['userid'];
    } else {
        echo "<div class='container py-5'><div class='alert alert-danger'>Admin user not found.</div></div>";
        exit();
    }
} else {
    $partner_db_id = $partner_id;
}

// Validate
if (empty($partner_db_id)) {
    echo "<div class='container py-5'><div class='alert alert-danger'>No chat partner specified.</div></div>";
    exit();
}

// ✅ Mark all messages from the partner as seen
$seen_stmt = $conn->prepare("UPDATE product_messages SET seen = 1 WHERE sender_id = ? AND receiver_id = ?");
$seen_stmt->bind_param("ss", $partner_db_id, $userid);
$seen_stmt->execute();

// ✅ Handle new message
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $message = trim($_POST['message']);
    $image = '';

    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = "../dashboard/uploads/";
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        $filename = time() . "_" . basename($_FILES['image']['name']);
        $filepath = $upload_dir . $filename;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $filepath)) {
            $image = $filename;
        }
    }

    // ✅ Insert new message
    $stmt = $conn->prepare("INSERT INTO product_messages (sender_id, receiver_id, sender_role, message, image) VALUES (?, ?, 'user', ?, ?)");
    $stmt->bind_param("ssss", $userid, $partner_db_id, $message, $image);
    $stmt->execute();
}
?>

<!-- Chat UI -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="container py-5">
    <h4 class="mb-4 text-center fw-bold text-white">
        Chat with <?php echo htmlspecialchars($partner_role === 'admin' ? 'Admin' : 'User'); ?>
    </h4>

    <div class="card shadow border-0 rounded-4">
        <div class="card-body p-4" style="height: 420px; overflow-y: auto; background: #f0f2f5;">
            <?php
            $msg_query = $conn->prepare("
                SELECT * FROM product_messages 
                WHERE (sender_id = ? AND receiver_id = ?) 
                   OR (sender_id = ? AND receiver_id = ?)
                ORDER BY sent_at ASC
            ");
            $msg_query->bind_param("ssss", $userid, $partner_db_id, $partner_db_id, $userid);
            $msg_query->execute();
            $result = $msg_query->get_result();

            if ($result->num_rows === 0) {
                echo "<div class='text-center text-muted'>No messages yet. Start the conversation!</div>";
            }

            while ($msg = $result->fetch_assoc()) {
                $isSender = $msg['sender_id'] === $userid;
                $msgAlign = $isSender ? 'justify-content-end' : 'justify-content-start';
                $msgBg = $isSender ? 'bg-primary text-white' : 'bg-white border';
                $rounded = $isSender ? 'rounded-start-4' : 'rounded-end-4';

                echo "<div class='d-flex $msgAlign mb-3'>
                        <div class='p-3 $msgBg $rounded shadow-sm' style='max-width: 75%; position: relative;'>
                            <div>" . nl2br(htmlspecialchars($msg['message'])) . "</div>";

                if (!empty($msg['image'])) {
                    echo "<img src='../dashboard/uploads/" . htmlspecialchars($msg['image']) . "' class='img-fluid rounded mt-2' style='max-height: 200px; max-width: 100%; object-fit: cover;'>";
                }

                echo "      <div class='text-end small mt-2 text-muted'>" . date('M d, h:i A', strtotime($msg['sent_at'])) . "</div>
                        </div>
                      </div>";
            }
            ?>
        </div>

        <!-- Send form -->
        <div class="card-footer bg-white p-3 border-top">
            <form method="POST" enctype="multipart/form-data" class="d-flex gap-2 align-items-center">
                <label for="image-upload" class="btn btn-light rounded-circle border" style="width: 40px; height: 40px;" title="Attach image">
                    <i class="fas fa-paperclip"></i>
                </label>
                <input type="file" name="image" id="image-upload" accept="image/*" style="display: none;">
                <input type="text" name="message" class="form-control rounded-pill px-4" placeholder="Type your message..." required autocomplete="off">
                <button type="submit" class="btn btn-success rounded-pill px-4">
                    <i class="fas fa-paper-plane me-1"></i> Send
                </button>
            </form>
        </div>
    </div>
</div>

<style>
    body.chat-page aside {
        display: none !important;
    }
    @media screen and (max-width: 576px) {
        .card-body {
            height: 400px !important;
        }
    }
</style>

<?php include "footer.php"; ?>
